import request from './api';

// 获取隐私协议
export const getAgreements = ( param ) => {
  return request({
    url: `/api-ws/agreements/`,
    method: 'get',
    params: param
  })
}
// 协议签订接口
export const signAgreements = ( data ) => {
  return request({
    url: `/api-ws/agreements/consent`,
    method: 'post',
    data: data,
    withCredentials: true
  })
}
// 统一验证接口，判断手机号是否注册是否设置密码，等等
export const verityStatus = ( data ) => {
  return request({
    url: `/account/unifiedVerification`,
    method: 'post',
    data: data
  })
}
// 获取RSA public key
export const getPubKey = ( param ) => {
  return request({
    url: `/account/cipher/key`,
    method: 'get',
    params: param
  })
}
//微信登录
export const wxLogin = ( data ) => {
  return request({
    url: `/account/login/wechat`,
    method: 'post',
    data: data
  })
}
//微信绑定手机号 并登录
export const wxBindMobile = ( data ) => {
  return request({
    url: `/account/login/wechat/step2`,
    method: 'post',
    data: data
  })
}

// 验证码登录
export const msgCodeLogin = data => {
  return request({
    url: `/account/account/login-register/v1`,
    method: 'post',
    data: data
  })
}

// 密码登录
export const passwordLoginReq = data => {
  return request({
    url: `/account/login`,
    method: 'post',
    data: data
  })
}
// 判断是否需要触发拼图风控
export const checkNeedImgCode = data => {
  return request({
    url: `/account/jigsawCode`,
    method: 'post',
    data: data
  })
}
// 获取短信验证码
export const getMessageCode = data => {
  return request({
    url: `/account/H5/authCode`,
    method: 'post',
    data: data
  })
}





















































