import { Toast } from 'vant';
import { CryptoJS } from './aes'

if (process.client) {
  require('jsencrypt')
}

import { getPubKey } from "@/service";

let pubKey = "";

// generate key
function getAesKey(len) {
  len = len || 16;
  var aesKey = "";
  var strList = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
  var strLen = strList.length;
  for(var i=0; i<len; i++){
  aesKey += strList.charAt( Math.floor( Math.random()*strLen ) );
  };
  return aesKey;
}

// 加密传参,发送请求
async function sendEncryptRequest(content, cb){
 console.log('content',content)
  content = JSON.stringify(content);  // 后端要求转 string
  let params = null
  if(pubKey){  // pubKey获取过就不用再获取了
    let params = formatContent(content, pubKey);
    cb && cb(params);
  }else{
    handleGetPubKey(content, cb);
  }
  return params
}

// get public key
function handleGetPubKey(content, cb){
  getPubKey().then(res => {
      // console.log('>>>>>>>>>>>>>>>>>>>> publicKey: ', res);
     /* if(res.status && res.status === 200) {
        res = res.data;
      }*/
      console.log('res',res)
      if(res.code == '000000'){
        pubKey = res.data;
        if(cb){
          let params = formatContent(content, pubKey);
          cb && cb(params);
        }
      }else{
          Toast({
            message: (res && res.message) || '接口出错',
            duration: 1500
          });
      }
  })
}

// format account params
function formatContent(content, pubKey) {  // obj为具体的json传参
  let aesKey = getAesKey(16);
  let params = {
      key: '',
      content: ''
  };

  params.content = AesEncrypt(content, aesKey);
  params.key = RsaEncrypt(aesKey, pubKey);
  return params;
}

// AES encrypt
function AesEncrypt(content, aesKey) {
  let sKey = CryptoJS.enc.Utf8.parse(aesKey);
  let sContent = CryptoJS.enc.Utf8.parse(content);
  let encrypted = CryptoJS.AES.encrypt(sContent, sKey, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
  return encrypted.toString();
}

// RSA encrypt
function RsaEncrypt(aesKey, pubKey){  
  let _encrypt = new JSEncrypt();
  let boss_public_key = pubKey;
  _encrypt.setPublicKey(boss_public_key);
  let encrypted = _encrypt.encrypt(aesKey);
  return encrypted;
}


export {
  getAesKey,
  sendEncryptRequest,
  handleGetPubKey,
  formatContent,
  AesEncrypt,
  RsaEncrypt,
}