// import { getHospital } from '@/service';

export const state = () => ({
  userToken:null,
  code: null, //微信登录返回的code
  unionId: null, //微信登录返回的unionId
  imgCodeData: {}, //拼图片验证码数据
  needTimer: false, //是否倒计时
});

export const mutations = {
  SET_TOKEN: (state, userToken) => {
    state.userToken = userToken
  },
  SET_CODE: (state, code) => {
    state.code = code
  },
  SET_UNIONID: (state, unionId) => {
    state.unionId = unionId
  },
  SET_IMGDATA: (state, imgCodeData) => {
    state.imgCodeData = imgCodeData
  },
  SET_NEEDTIMER: (state, needTimer) => {
    state.needTimer = needTimer
  },
};

export const actions = {
  setToken({ commit }, userToken) {
    commit('SET_TOKEN', userToken)
  },
  setCode({ commit }, code) {
    commit('SET_CODE', code)
  },
  setUnionId({ commit }, unionId) {
    commit('SET_UNIONID', unionId)
  },
  setImgCodeData({ commit }, imgCodeData) {
    commit('SET_IMGDATA', imgCodeData)
  },
  setNeedTimer({ commit }) {
    commit('SET_NEEDTIMER', true)
  },
};
