// import fetch from '@/utils/fetch';
// import { getBaseUrl } from '@/utils/index'
// import { setCookie, getCookie, delCookie } from '@/utils/index';
// import { envConfig } from '@/utils/env-config';
import { findQuestionIndexNo, getOrderText, concatArray } from "@/utils";

const question = {
  state: {
    currentTitle: "题库",
    questionList: [],
    currentQuestion: {
      isAnalyzed: false,
      options: [         // 从options加工出来
        {
          isCorrect: false,
          isSelected: true,
          text: "进行分析评估",
        },
        {
          isCorrect: false,
          isSelected: false,
          text: "进行分析评估",
        },
        {
          isCorrect: true,
          isSelected: true,
          text: "进行分析评估",
        },
        {
          isCorrect: false,
          isSelected: false,
          text: "进行分析评估",
        },
      ],
      titleId: 1,
      titleNo: 1,           // 题序，从1开始
      typeId: 1,            // 题目类型ID 1-单选，2-多选，3-判断
      unionId: "",          // 联合类型题目，分组唯一标识
      unionType: 1,         // 0普通题型 1-共用题干； 2-共用选项
      unionQuestion: "",    // 共用题干
      question: '题干内容<img src="https://files.yunqueyi.com/image/png/protal/project/20200702161856970.png" />',   // 题干内容
      config: "",           // 选项
      answer: "",           // 正确答案
      intro: "",            // 题目解析
      score: 0,             // 题目分值
      myAnswer: "",         // 我的答案
      commitFlag: 0,        // 0还未做 1做对了 2做错了
      favorFlag: 0,         // 0未收藏 1已收藏
      pictureFlag: "",      // 0没有图 1有图
      questionStreamType: "",   // 题干内流媒体类型：0-文本，1-图片，2-视频，3-音频
      directoryId: 0,       // 题库ID
      paperId: "",          // 试卷ID
      paperIndex: "",       // 试卷索引
    },
    commonConfig: {
      // 0: 免费; 1: 收费;  没有绑卡且是收费题库（bindStatus == 0 && freeFlag == 1）可以走免费体验流程   
      freeFlag: 0,
      directoryId: "",
      secondSubjectId: 0,
      cardType: 3,
      goodsType: 3,
      commitKind: 3,            // 答题来源 1：错题集 2：收藏 3：题库
    },
    titleConfig: {
      bindStatus: 0,            // 绑卡状态：0未绑卡 1已绑卡
      commitKind: 3,            // 答题来源 1：错题集 2：收藏 3：题库
      currentTitleNo: 0,        // 定位答题题目id
      resultId: 0,              // 刷题库轮次ID
      totalCount: 0,            // 题目总数
    },
    canRunNext: true,
  },
  mutations: {
    SET_COMMON_CONIFG: (state, payload) => {
      state.commonConfig = payload;
    },
    SET_TITLE_CONIFG: (state, payload) => {
      state.titleConfig = payload;
    },
    SET_COMMIT_KIND: (state, payload) => {
      state.titleConfig.commitKind = payload;
    },
    SET_FREE_FLAG: (state, payload) => {
      state.titleConfig.freeFlag = payload;
    },
    SET_TOTAL_COUNT: (state, payload) => {
      state.titleConfig.totalCount = payload;
    },
    SET_QUESTION_LIST: (state, payload) => {
      state.questionList = payload;
    },
    SET_CURRENT_QUESTION: (state, payload) => {
      state.currentQuestion = payload;
    },
    SET_CAN_RUN_NEXT: (state, payload) => {
      state.canRunNext = payload;
    },
  },
  actions: {

    // 处理返回的数据
    handlerQuestionList({ commit, state }, rezultData) {
      let questionList = rezultData.practiseTitleModelList || [];
      let handlerList = [], question, option, optionList = [], myAnswer = "",
          answer = "", questionContent = "";
      questionList.forEach((item, index) => {
        myAnswer = item.myAnswer;
        answer = item.answer;
        question = JSON.parse(JSON.stringify(item));
        question.unionQuestion = question.unionQuestion.replace(/<img/, '<img style="max-width:98%;"');
        question.question = question.question.replace(/<img/, '<img style="max-width:98%;"');
        question.intro = question.intro.replace(/<img/, '<img style="max-width:98%;"');
        let isAnalyzed = question.commitFlag && myAnswer != answer;
        question.isAnalyzed = isAnalyzed;
        option = {};
        optionList = [];
        question.options.forEach((text, i) => {
          option.isCorrect = answer.indexOf(getOrderText(i)) != -1;
          if (myAnswer.indexOf(getOrderText(i)) != -1) {
            option.isSelected = true;
          } else {
            option.isSelected = false;
          }
          option.text = text;
          optionList.push(JSON.parse(JSON.stringify(option)));
        });
        question.options = optionList;
        console.log('handlerList', index);
        handlerList.push(question);
      });
      console.log('in handlerList', handlerList);
      let newList = concatArray(state.questionList, handlerList, 'titleNo');
      commit("SET_QUESTION_LIST", newList);

      if (rezultData.isFirst) {
        let cIndex = findQuestionIndexNo(handlerList, 'titleNo', rezultData.currentTitleNo || 1);
        let titleConfig = {
          bindStatus: rezultData.bindStatus,            // 绑卡状态：0未绑卡 1已绑卡
          commitKind: rezultData.commitKind,            // 答题来源 1：错题集 2：收藏 3：题库
          currentTitleNo: rezultData.currentTitleNo,    // 定位答题题目id
          resultId: rezultData.resultId,                // 刷题库轮次ID
          totalCount: rezultData.totalCount,            // 题目总数
        }
        commit("SET_CURRENT_QUESTION", newList[cIndex] || { titleNo: 1 });
        commit("SET_TITLE_CONIFG", titleConfig);
      }
    },

  },
}

export default question;
