import Vue from 'vue';
import Router from 'vue-router';

Vue.use(Router);

export default new Router({
    /*
    * 在创建的 router 对象中，如果不配置 mode，就会使用默认的 hash 模式，该模式下会将路径格式化为 #! 开头。
    * 添加 mode: 'history' 之后将使用 HTML5 history 模式，该模式下没有 # 前缀，而且可以使用 pushState 和 replaceState 来管理记录。
    * 关于 HTML5 history 模式的更多内容，可以参考官方文档：https://router.vuejs.org/zh-cn/essentials/history-mode.html
    */
    //mode: 'history',
    routes: [
        {

            path: '/',
            component: resolve => require(['../components/common/Home.vue'], resolve),
            children: [
                {
                    path: '/',
                    redirect: '/doctor-black',
                   
                },{
                    path: '/doctor-black',
                    component: resolve => require(['../views/black-list/doctor-black.vue'], resolve),
                },{
                    path: '/empty-phone',
                    component: resolve => require(['../views/black-list/empty-phone.vue'], resolve),
                },
            ]
        },
        
        

    ]
})
