import Vue from 'vue';
import Router from 'vue-router';

Vue.use(Router);

export default new Router({
    /*
    * 在创建的 router 对象中，如果不配置 mode，就会使用默认的 hash 模式，该模式下会将路径格式化为 #! 开头。
    * 添加 mode: 'history' 之后将使用 HTML5 history 模式，该模式下没有 # 前缀，而且可以使用 pushState 和 replaceState 来管理记录。
    * 关于 HTML5 history 模式的更多内容，可以参考官方文档：https://router.vuejs.org/zh-cn/essentials/history-mode.html
    */
    //mode: 'history',
    routes: [
        {

            path: '/',
            component: resolve => require(['../components/common/Home.vue'], resolve),
            children: [
                {
                    path: '/',
                    redirect: '/data-view',
                   
                },{ // 数据导入
                    path: '/data-in',
                    component: resolve => require(['../views/sensitive-control/data-in.vue'], resolve),
                }, { // 数据统计
                    path: '/data-statistic',
                    component: resolve => require(['../views/sensitive-control/data-statistic.vue'], resolve),

                },{ // 数据查看
                    path: '/data-view',
                    component: resolve => require(['../views/sensitive-control/data-view.vue'], resolve)
                },
                {  // 用户路径分析
                    path: '/user-path',
                    component: resolve => require(['../views/user-path/funnel.vue'], resolve)
                },
                {  // 用户路径分析--新增转化漏斗
                    path: '/add-funnel',
                    component: resolve => require(['../views/user-path/add-funnel.vue'], resolve)
                },
                {  // 用户路径分析--查看数据
                    path: '/path-data',
                    component: resolve => require(['../views/user-path/funnel-data.vue'], resolve)
                },
            ]
        },
        {  // 短信中的 数据查看页面
            path: '/data-view-message',
            component: resolve => require(['../views/sensitive-control/data-view-message.vue'], resolve)
        },
        

    ]
})
