import "babel-polyfill";
import Vue from 'vue';
import App from './App';
import router from './router';
import store from './vuex/store'
import axios from 'axios';
import ElementUI from 'element-ui';
import echarts from 'echarts';
import 'element-ui/lib/theme-chalk/index.css';    // 默认主题
import {getAddress, loadCommonFilter} from './common/env'
import vueFilter from './common/filter';

import vViewer from 'v-viewer';
import 'viewerjs/dist/viewer.css';


//加载环境变量
getAddress();
loadCommonFilter();
//加载elementUi
Vue.use(ElementUI);
Vue.use(vViewer);
Vue.prototype.$echarts = echarts;
// Vue.use(vueXlsxTable, {rABS: false})

if (localStorage.getItem("token")) {
    Vue.prototype.$axios = axios.create({
        headers: {
            'token': localStorage.getItem("token"),
            'sysCode': localStorage.getItem("sysCode"),
            'deviceInfo': localStorage.getItem("deviceInfo"),
        }
    });
} else {
    Vue.prototype.$axios = axios;
}

// 全局过滤器
for (const filter in vueFilter) {
    Vue.filter(filter, vueFilter[filter])
}

new Vue({
    router,
    store,
    render: h => h(App)
}).$mount('#app');
