import { isEmptyUtils, openLoading, closeLoading } from './utils'
import { doUpload, getFilePath } from "./qiniuUtil"
/**
 * 活动模板公共上传图片及其尺寸限制
 * @param {*} file 
 * @param {*} vm 
 * @param {*} pageWidth 
 */
export function commonUploadImg(file,vm,pageWidth) {
    return new Promise(function (resolve, reject) {
        let isLtSize = ''
        if( file.type === 'image/gif') {
            isLtSize = file.size / 1024  < 300
        }else if( file.type === 'image/jpeg' || file.type === 'image/png'){
            isLtSize = file.size / 1024  < 100
        }
        if(!isLtSize) {
            vm.$message.error('上传图片过大')
            return;
        }
        let imgWidth = parseInt(parseInt(pageWidth)/(vm.editTabOrImgForm.length))
        var _img = new FileReader()
        _img.readAsDataURL(file)
        _img.onload = function(theFile) {
            let image = new Image()
            image.src = theFile.target.result
            image.onload = function() {
                let _this = this
                if(_this.width != imgWidth) {
                    vm.$message.info('上传图片宽度不合适，请重新上传')  
                }else {
                    vm.$message.info('开始上传');
                    openLoading(vm)
                    doUpload(vm,file, getFilePath(file,null), 'preview4', 'progress1', 1).then(function (path) {
                        closeLoading(vm)
                        resolve(path)
                    });
                }    
            }
        }  
    })
}

/**
 * 栏位上传图片
 * @param {*} file 
 * @param {*} vm 
 */
export function columnCommonUploadImg(file,vm) {
    if (isEmptyUtils(file)) {
        return;
    }
    const isJPG = file.type === 'image/jpeg'
    const isPNG = file.type === 'image/png'
    const isGIF = file.type === 'image/gif'
    const isLt100kb = file.size / 1024 < 100
    if (!isLt100kb) {
        vm.$message.error('上传图片大小不能超过 100kb')
        return;
    }
    if (!isJPG && !isPNG && !isGIF) {
        vm.$message.error('上传头像图片只能是 JPG、png、gif格式!')
        return;
    }
    for(let i = 0;i < vm.tabContent.length; i++) {
        if(vm.imgIndex == i) {
            vm.imgWidth = vm.tabContent[i].contentResourceField.width
            vm.imgHeight = vm.tabContent[i].contentResourceField.height
            var _img = new FileReader()
            _img.readAsDataURL(file)
            _img.onload = function(theFile) {
                let image = new Image()
                image.src = theFile.target.result
                image.onload = function() {
                    let _this = this
                    if(_this.width != vm.imgWidth || _this.height != vm.imgHeight) {
                        vm.$message.info("上传图片尺寸大小不合适，请重新上传")
                    }else {
                        vm.doUpload(file)  //上传图片
                    }    
                }
            }
            break
        }   
    }
}

// 字符长度的校验
export function getStrCodeNum(str) {
    if(!/^[\u0391-\uFFE5A-Za-z]+$/.test(str)) {
        return false
    }
    let num = 0
    for(let i=0;i<str.length;i++) {
        if(str.charCodeAt(i) >= 1000) {
            num = num + 2
        }else{
            num = num + 1
        }
    }
    if( num > 30) {
        return false
    }
    return true
}