import fetch from './fetch.js';
export const positionService = {
    isDirectProvince(province_id){
        return province_id == 110 || province_id == 120 || province_id == 310 || province_id == 500;
    },
    townButtonDisable(province_id){
        if(this.isDirectProvince(province_id)) {
            return true;
        }else {
            return false;
        }
    },
    //获取省分
    getProvinceList() {
            let num = {token: localStorage.getItem("token")};
        let promise = fetch(localStorage.getItem("kfUrl") + "PICAPositionServiceImpl/getProvinceList",
            num,
            'POST'
        );
            return promise;
    },
    //获取省分(区域权限)
    getProvinceByRegionRole(){
        let promise = new Promise(function(resolve, reject) {
            var num = {token: localStorage.getItem("token")};
            let ret = fetch(localStorage.getItem("kfUrl") + 'PICAPositionServiceImpl/getProvinceList', num);
            ret.then(function (data) {
                let provinceListTemp = Object.assign({},data.provinceList);
                let provinceListData = new Array();
                //有区域权限时
                if (region_role != null && region_role != "") {
                    var regionRoles = region_role.split(',');
                    for (var j = 0; j < regionRoles.length; j++) {
                        for (var i = 0; i < provinceListTemp.length; i++) {
                            if (regionRoles[j] == provinceListTemp[i].province_id) {
                                provinceListData.push(provinceListTemp[i]);
                                break;
                            }
                        }
                    }
                } else {
                    //没有限制时,放入全部
                    provinceListData = provinceListTemp;
                }
                resolve(provinceListData);
            },function (fail) {
                reject();
            })
        });
        return promise;
    },

    // 获取市
    getCityListData (province_id,success, error, otherOptions) {
        var num = {
            province_id : province_id
        }
        let promise = fetch(localStorage.getItem("kfUrl") + "PICAPositionServiceImpl/getCityList", num);
        return promise;
    },

    getCountyListData(city_id,success, error, otherOptions) {
        var num = {
            city_id : city_id
        }
        let promise = fetch(localStorage.getItem("kfUrl") + "PICAPositionServiceImpl/getCountyList", num);
        return promise;
    },

    //获取乡镇
    getTownListData(county_id,success) {
        var num = {
            county_id : county_id
        }
        let promise = fetch(localStorage.getItem("kfUrl") + "PICAPositionServiceImpl/getTownList", num);
        return promise;
    },

    // 获取医生集合 type为3表示3级医院 4表示4级医院 5表示5级医院
    getHospitalListData(county_id, town_id, rank) {
        var num = {
            county_id : county_id,
            town_id : town_id,
            rank : rank
        }
        let promise = fetch(localStorage.getItem("kfUrl") + "PICAAddressHospitalServiceImpl/postHospitalListByRank", num);
        return promise;
    }
}
