import fetch from '../common/fetch'

let headers = {
    headers: {
        'token': localStorage.getItem('token') || null
    }
};

const resource = {
    resourceList(data,self){
        // return fetch(localStorage.getItem("msUrl")+'admin/resources/list', data, 'POST','fetch')
        return self.$axios.post(localStorage.getItem("msUrl")+'admin/resources/list', data, headers)
    },
    delResource(id,data,self){
        // return fetch(localStorage.getItem("msUrl")+`admin/resources/${id}`, data, 'delete','fetch')
        return self.$axios.delete(localStorage.getItem("msUrl")+`admin/resources/${id}`, data)
    },
    saveResource(data,self){
        return self.$axios.post(localStorage.getItem("msUrl")+`admin/resources/upload`, data, headers)
    },
    savePersistent(data,self){
        return self.$axios.post(localStorage.getItem("msUrl")+`admin/qiniu/persistent`, data, headers)
    },
    checkFileName(data,self){
        return self.$axios.post(localStorage.getItem("msUrl")+`admin/resources/filecheck`, data, headers)
    },
    updateName(data,self){
        return self.$axios.post(localStorage.getItem("msUrl")+`admin/resources/updateName`, data, headers)
    },
    queryList(data,self){
        return self.$axios.post(localStorage.getItem("msUrl")+`admin/roster/queryList`, data, headers)
    },
    selectUser(data,self){
        return self.$axios.get(localStorage.getItem("msUrl")+`admin/roster/selectUser`, data, headers)
    },
    selectRosterById(data,self){
        return self.$axios.get(localStorage.getItem("msUrl")+`admin/roster/selectRosterById?id=${data.id}`, data, headers)
    },
    insertOrUpdate(data,self){
        return self.$axios.post(localStorage.getItem("msUrl")+`admin/roster/insertOrUpdate`, data, headers)
    },
    upperOrLowerShip(data,self){
        return self.$axios.get(localStorage.getItem("msUrl")+`admin/roster/upperOrLowerShip?id=${data.id}&status=${data.status}`, data, headers)
    },
    clearData(data,self){
        return self.$axios.get(localStorage.getItem("msUrl")+`admin/roster/clearData?id=${data.id}`, data, headers)
    },
}

export default resource
