import Vue from 'vue';
import Router from 'vue-router';

Vue.use(Router);

export default new Router({
    /*
    * 在创建的 router 对象中，如果不配置 mode，就会使用默认的 hash 模式，该模式下会将路径格式化为 #! 开头。
    * 添加 mode: 'history' 之后将使用 HTML5 history 模式，该模式下没有 # 前缀，而且可以使用 pushState 和 replaceState 来管理记录。
    * 关于 HTML5 history 模式的更多内容，可以参考官方文档：https://router.vuejs.org/zh-cn/essentials/history-mode.html
    */
    // mode: 'history',
    routes: [
        {
            path: '/',
            component: resolve => require(['../components/common/Home.vue'], resolve),
            children: [
                {
                    path: '/',
                    redirect: '/data-in'
                },{ // 后台编码库
                    path: '/code-library',
                    component: resolve => require(['../views/code-library/code-library.vue'], resolve),
                },{ // 常见诊断管理
                    path: '/diagnose-manage',
                    component: resolve => require(['../views/diagnose-manage/diagnose-manage.vue'], resolve)
                },{ // 后台编码库
                    path: '/data-in',
                    component: resolve => require(['../views/sensitive-control/data-in.vue'], resolve),
                },{ // 常见诊断管理
                    path: '/data-view',
                    component: resolve => require(['../views/sensitive-control/data-view.vue'], resolve)
                }


            ]
        }


    ]
})
