import {isNotEmptyUtils} from "./utils";
import Vue from 'vue';

/**
 * 配置编译环境和线上环境之间的切换
 */
const getTestEnv = (ipAddress) => {
    let environments = ["uat", "test3", "test2", "test1", "dev"];
    for (let i = 0; i < environments.length; i++) {
        if (ipAddress.indexOf(environments[i]) > -1) {
            return environments[i];
        }
    }
    return null;
};

//获取服务器路径
export const getAddress = () => {
    let ipAddress = "https://" + window.location.host;
    // let ipAddress = "http://localhost:8099";
    let env = getTestEnv(ipAddress);
    let versionUrl = "";
    let preViewUrl = ""
    let qiniuImgUrl  = "";
    let qiniuFileUrl = '';
    let resource_url = "";
    let exam_url = "";
    let locationHost = "";//模板文件路径
    let stsUrl = "";//sts服务器//获取OSS客户端
    let bucketName = "";
    let endpoint = "";
    let Url = "";//访问后台的域名
    let msUrl = "";//Micro service url
    let liveUrl = "";//Micro service url
    let lectureUrl = '';
    let ossLogin = "";//内部系统登录页面
    let template_url = "";//题库模板服务器
    let kfUrl="";//暂时代替微服务，提供 市区县医院 常量 部门 职称 的服务
    let qiniuUrl = "";//qiniu验证服务器
    let qiniuResourceUrl = "";//qiniu存储域名

    //本地
    if (ipAddress.indexOf("localhost") > -1 || ipAddress.indexOf("10.177.10.118") > -1 || ipAddress.indexOf("test-kf") > -1) {
        ipAddress = "http://localhost:7070";
        versionUrl = 'https://dev-dev.yunqueyi.com';
        preViewUrl = "http://localhost:9090/#/template";
        qiniuImgUrl = "https://test1-file.yunqueyi.com";
        resource_url = "https://test-file.yunqueyi.com";
        exam_url = "https://test1-sc.yunqueyi.com/exams";
        locationHost = "http://test-kf.yunqueyi.com";
        stsUrl = "http://dev-api.yunqueyi.com/middle/oss/token";//sts服务器
        bucketName = "pica-test-huabei2";
        endpoint = "oss-cn-beijing.aliyuncs.com";
        Url = ipAddress + "/ADMIN_CMS_FE/rest/";
        //msUrl = "http://10.177.15.117:10201" + "/contents/";
        // msUrl = "http://10.177.15.154:10203" + "/contents/";
        msUrl = "https://dev-sc.yunqueyi.com" + "/contents/";
        lectureUrl = "https://dev-sc.yunqueyi.com"
        liveUrl = "https://dev-sc.yunqueyi.com/campaign/";
        kfUrl = "http://test1-kf.yunqueyi.com" + "/api/";
        ossLogin = "http://localhost:8090/PICA_SSO_FE/html/pica_login.html";
        template_url = ipAddress
        // qiniuUrl = "http://10.177.15.154:10203/contents/admin/qiniu/token"; //不再使用middle服务获取七牛token
        qiniuUrl = "https://dev-sc.yunqueyi.com/contents/admin/qiniu/token";
        // qiniuFileUrl = "http://10.177.15.154:10203/contents/admin/qiniu/token1";
        qiniuFileUrl = "https://dev-sc.yunqueyi.com/contents/admin/qiniu/token1";
        qiniuResourceUrl = "https://test1-videos.yunqueyi.com";
    } else if (isNotEmptyUtils(env)) {//测试test1 test2 uat
        versionUrl = 'https://' + env + '-dev.yunqueyi.com';
        preViewUrl = "https://" + env + "-phome.yunqueyi.com" + "/template/#/template"
        qiniuFileUrl = "https://" + env + "-sc.yunqueyi.com" + "/contents/admin/qiniu/token1";
        qiniuImgUrl = "https://test1-file.yunqueyi.com";
        resource_url = "https://test-file.yunqueyi.com";
        locationHost = "https://" + env + "-admin-md.yunqueyi.com";
        exam_url = "https://" + env + "-sc.yunqueyi.com/exams";
        stsUrl = "https://" + env + "-api.yunqueyi.com/middle/oss/token";//sts服务器
        bucketName = "pica-test-huabei2";
        endpoint = "oss-cn-beijing.aliyuncs.com";
        Url = ipAddress + "/api/";
        kfUrl = "https://" + env + "-kf.yunqueyi.com" + "/api/";
        msUrl = "https://" + env + "-sc.yunqueyi.com" + "/contents/";
        liveUrl = "https://" + env + "-sc.yunqueyi.com" + "/campaign/";
        lectureUrl = "https://" + env + "-sc.yunqueyi.com"
        ossLogin = "https://" + env + ".yunqueyi.com";
        template_url = "https://" + env + "-project.yunqueyi.com";
        qiniuUrl = "https://" + env + "-sc.yunqueyi.com" + "/contents/admin/qiniu/token";
        qiniuResourceUrl = "https://test1-videos.yunqueyi.com";
        /*
        * uat做特殊处理(图片等文件)
        * uat图片使用生产的,因为DB数据从生产同步下来的,web,app端使用的都是生产的图片路径
        * 所以admin上传也上传到生产
        * */
        if (env === "uat") {
            // qiniuImgUrl = "https://files.yunqueyi.com";//qiniu存储域名
            resource_url = "https://file.yunqueyi.com";
            bucketName = "pica-pro";
            endpoint = "oss-cn-shanghai.aliyuncs.com";
            // qiniuResourceUrl = "https://video.yunqueyi.com";//qiniu存储域名
            exam_url = "https://" + env + "-sc.yunqueyi.com/exams";
            lectureUrl = "https://" + env + "-sc.yunqueyi.com"
        }
    } else {//生产环境
        versionUrl = 'https://dev.yunqueyi.com';
        preViewUrl = "https://phome.yunqueyi.com" + "/template/#/template"
        qiniuFileUrl = "https://sc.yunqueyi.com" + "/contents/admin/qiniu/token1";
        qiniuImgUrl = "https://files.yunqueyi.com";//qiniu存储域名
        resource_url = "https://file.yunqueyi.com";
        locationHost = ipAddress;
        stsUrl = "https://api.yunqueyi.com/middle/oss/token";//sts服务器
        bucketName = "pica-pro";
        endpoint = "oss-cn-shanghai.aliyuncs.com";
        Url = ipAddress + "/api/";
        msUrl = "https://sc.yunqueyi.com" + "/contents/";
        liveUrl = "https://sc.yunqueyi.com" + "/campaign/";
        lectureUrl = "https://sc.yunqueyi.com"
        kfUrl = "https://kf.yunqueyi.com" + "/api/";
        ossLogin = "https://sso.yunqueyi.com";
        template_url = "https://project.yunqueyi.com";
        qiniuUrl = "https://sc.yunqueyi.com" + "/contents/admin/qiniu/token";
        qiniuResourceUrl = "https://video.yunqueyi.com";//qiniu存储域名
        exam_url = "https://sc.yunqueyi.com/exams";
    }
    localStorage.setItem("versionUrl",versionUrl);
    localStorage.setItem("preViewUrl",preViewUrl);
    localStorage.setItem("qiniuFileUrl", qiniuFileUrl);
    localStorage.setItem("qiniuImgUrl", qiniuImgUrl);
    localStorage.setItem("resource_url", resource_url);
    localStorage.setItem("locationHost", locationHost);
    localStorage.setItem("Url", Url);
    localStorage.setItem("msUrl", msUrl);
    localStorage.setItem("liveUrl", liveUrl);
    localStorage.setItem("lectureUrl", lectureUrl);
    localStorage.setItem("kfUrl", kfUrl);
    localStorage.setItem("examUrl", exam_url);
    localStorage.setItem("stsUrl", stsUrl);//sts服务器
    localStorage.setItem("bucketName", bucketName);//oss
    localStorage.setItem("endpoint", endpoint);//oss
    localStorage.setItem("ossLogin", ossLogin);//内部系统登录页面
    localStorage.setItem("template_url", template_url);
    localStorage.setItem("qiniuUrl", qiniuUrl);//qiniu验证服务器
    localStorage.setItem("qiniuResourceUrl", qiniuResourceUrl);//qiniu存储域名
    localStorage.setItem("sysCode", '3');//admin_cms系统编号
    localStorage.setItem("deviceInfo", "{\"app_channel\":\"\",\"app_mac\":\"\",\"app_uuid\":\"\",\"app_version\":\"\",\"device_brand\":\"\",\"device_ip\":\"\",\"device_model\":\"\",\"device_net\":\"\",\"device_ops\":\"\",\"resolution_wh\":\"\",\"system_level\":\"\"}");//deviceInfo
};


export const loadCommonFilter = () => {
    /**
     * 常量过滤器
     * @name constantFilter
     * @description:用于将[no:枚举值]转换成[value:枚举名称]
     * @param {Number} [input] 要过滤的对象
     * @param {Array} [enumList] 常量列表
     */
    Vue.filter('constantFilter', function (input, enumList) {
        let hash = {};
        if (enumList != null && enumList.length > 0) {
            for (let i = 0; i < enumList.length; i++) {
                hash[enumList[i].no] = enumList[i].value;
            }
        }
        if (!input) {
            return '';
        } else {
            return hash[input];
        }
    });
};
