const coop = {
  state: {
    userInfo: {},
    statusBarHeight: {},
    projectTabIndex: 1
  },
  mutations: {
    SET_USER_INFO: (state, userInfo) => {
      state.userInfo = userInfo
    },
    SET_STATUS_BAR_HEIGHT: (state, statusBarHeight) => {
      state.statusBarHeight = statusBarHeight
    },
    SET_PROJECT_TAB_INDEX: (state, projectTabIndex) => {
      state.projectTabIndex = projectTabIndex
    },
  },
  actions: {
    setUserInfo({ commit }, userInfo) {
      commit('SET_USER_INFO', userInfo)
    },
    setStatusBarHeight({ commit }, statusBarHeight) {
      commit('SET_STATUS_BAR_HEIGHT', statusBarHeight)
    },
    setProjectTabIndex({ commit }, projectTabIndex) {
      commit('SET_PROJECT_TAB_INDEX', projectTabIndex)
    },
  }
}

export default coop
