/**
 * Created by Anndy Yang on 18/09/18.
 */

export function setEventByModuleCode(itemData){
  let modeCode = itemData.appModuleInfo.code || '';
  let paramList = itemData.appModuleInfo.paramList ? itemData.appModuleInfo.paramList : ''
  if( modeCode === 'M001' || modeCode === 'M002' || modeCode === 'M003') {
      paramList = ''
  }else if( modeCode === 'M100' || modeCode === 'M300' ) {
     
    let urlPara = getUrlParmByCode(paramList);
    paramList[0] && (paramList[0].value += urlPara);

  }else if( modeCode === 'M400') {

      let path = paramList[0]['key'];
      let v = paramList[0]['value'];
      let query = setRouterParm(paramList);

      //console.log(Vue);
      // this.$router.push({
      //   path: v,
      //   query:query
      // })
  }
  if(typeof paramList === 'string' && !paramList){
      paramList = []
  }

  return paramList;
}

function getUrlParmByCode(paramList) {
    if ( paramList.length <= 1) {
        return ''
    }
    let dataStr = ''
    let list = [];
    for( let i = 1; i < paramList.length; i ++) {
        list.push(paramList[i].key + '=' + paramList[i].value)
    }
    dataStr = list.join('&')
    if (dataStr !== '') {
        return '?' + dataStr
    }
    return ''
}

export function deepCopy(obj) {
  var result = Array.isArray(obj) ? [] : {};
  for (var key in obj) {
    if (obj.hasOwnProperty(key)) {
      if (typeof obj[key] === 'object') {
        result[key] = deepCopy(obj[key]);   //递归复制
      } else {
        result[key] = obj[key];
      }
    }
  }
  return result;
}

export function pageJumpUrl(){
  let url = { 
    pageListUrl : 'https://test1-contents.yunqueyi.com/content_list',
    detailUrl : 'https://test1-contents.yunqueyi.com/content_detail'
  };
  return url;
}

export function sortParmData(originData, orderCol, index) {
  return originData.sort((a, b) => {
    return (a[orderCol] - b[orderCol] ) * -1
  })
}

// 获取SC服务器域名地址
export function getBaseUrl(url) {
  return getConfigByEvtType('baseUrl') + url
}

// 获取API服务器域名地址
export function getApiUrl(url) {
  return getConfigByEvtType('apiUrl') + url
}

// 获取WEB部署服务器域名地址
export function getWebPageUrl(url) {
  return getConfigByEvtType('webPageUrl') + url
}

// 根据不同环境，生成URL
function getConfigByEvtType(url) {
  return evtConfig[process.env.OWNER_ENV][url]
}

const evtConfig = {
  development: {
    baseUrl: 'https://dev-sc.yunqueyi.com/',
    // baseUrl: 'http://10.177.15.180:10202/',
    // baseUrl: 'http://192.168.140.14:10201/',
    apiUrl: 'https://dev-api.yunqueyi.com/',
    webPageUrl: 'https://dev-phome.yunqueyi.com/'  
  },
  dev: {
    baseUrl: 'https://dev-sc.yunqueyi.com/',
    apiUrl: 'https://dev-api.yunqueyi.com/',
    webPageUrl: 'https://dev-phome.yunqueyi.com/'  
  },
  test: {
    baseUrl: 'https://test1-sc.yunqueyi.com/',
    apiUrl: 'https://test1-api.yunqueyi.com/',
    webPageUrl: 'https://test1-phome.yunqueyi.com/'  
  },
  uat: {
    baseUrl: 'https://uat-sc.yunqueyi.com/',
    apiUrl: 'https://uat-api.yunqueyi.com/',
    webPageUrl: 'https://uat-phome.yunqueyi.com/'  
  },
  pro: {  
    baseUrl: 'https://sc.yunqueyi.com/',
    apiUrl: 'https://api.yunqueyi.com/',
    webPageUrl: 'https://phome.yunqueyi.com/'
  }
}

