import fetch from '@/utils/fetch'
import { getBaseUrl, getApiUrl } from '@/utils/index'

module.exports = {
    data: function () {
        return {
            // isIpx: Utils.env.isIPhoneX(),//是不是iphoneX
            // isAndroid: Utils.env.isAndroid(),
            // isIOS: false,
            // isWeb: false,
            token: null
        }
    },
    created: function () {
        let query = this.$router.query
        // this.token = this.getUrlSearch(location.href, 'token') || (query && query.token) || null
        this.token = this.getUrlKey('token') || (query && query.token) || null
    },
    mounted() {

    },
    methods: {
        getUrlPara(obj) {
            let dataStr = ''
            let list = [];
            for (let attr in obj) {
                if (obj.hasOwnProperty(attr) && attr != 'data') {
                    list.push(attr + '=' + obj[attr])
                }
            }
            dataStr = list.join('&')
            if (dataStr !== '') {
                return '?' + dataStr
            }
            return ''
        },
        pageBurialPoin(options){
            
            let opt = {
                menuLevel:options.menuLevel || '',
                functionCode:options.functionCode || '',
                actionCode: options.actionCode || '',
               // label:options.label || '',
                labelId:options.labelId || '',
                labelValue :options.labelValue  || '',
                createdTime: options.createdTime || new Date().getTime(),
                //type: options.type || '0',
                menuCode: options.menuCode || '',
              //  menuToCode:options.menuToCode || '',
                duration: options.duration || 0,
                menuFromCode:options.menuFromCode ||'',
                params:options.params || '',
                session:options.session || '',
            }
            console.log(opt);
            rocNative.appBuryingPointEntrust(opt)
        },

        setRouterParm(paramList){
            let parm = {};
            if(paramList.length<=1){
                return '';
            }
            for(let i=1;i<paramList.length;i++){
                parm[paramList[i].key] = paramList[i].value;
            }
            return parm;
        },

        // 拼接多个参数
        getUrlParmByCode(paramList) {
            if ( paramList.length <= 1) {
                return ''
            }
            let dataStr = ''
            let list = [];
            for( let i = 1; i < paramList.length; i ++) {
                list.push(paramList[i].key + '=' + paramList[i].value)
            }
            dataStr = list.join('&')
            if (dataStr !== '') {
                return '?' + dataStr
            }
            return ''
        },

        setEventByModuleCode(itemData){
           console.log(itemData);
            let modeCode = itemData.appModuleInfo.code || '';
            let paramList = itemData.appModuleInfo.paramList ? itemData.appModuleInfo.paramList : ''

            if( modeCode === 'M001' || modeCode === 'M002' || modeCode === 'M003') {
                paramList = ''
            }else if( modeCode === 'M100' || modeCode === 'M300' ) {
                // 支持多个参数
                let urlPara = this.getUrlParmByCode(paramList);
                if(paramList[0]){
                    if( paramList[0].value.indexOf("?") == -1){
                        paramList[0].value += urlPara
                    }
                }
            } else if (modeCode === 'M400') {
                let path = paramList[0]['key'];
                let v = paramList[0]['value'];
                let query = this.setRouterParm(paramList);
                paramList = [{
                    url:v,
                    query:query
                }]
                //alert(this.token);
               
            }
            if(typeof paramList === 'string' && !paramList){
                paramList = []
            }
            console.log(paramList);
            return paramList;
        },

        // 通用GET请求
        GET(api, para, callback,str) {
            para.token = para.token || this.token || 'FA95BE7379684E419050F72BCEB0DE12'
            let url = api + this.getUrlPara(para)
            return fetch({
                url: getBaseUrl(url),
                method: 'get',
                data: para
            })
        },

        // 通用POST请求
        POST(api, para, callback) {
            para.token = para.token || this.token || 'FA95BE7379684E419050F72BCEB0DE12'
            return fetch({
                url: getBaseUrl(api),
                method: 'post',
                data: para
            })
        },
        
        // 通用GET请求
        API_GET(api, para, callback) {
            para.token = para.token || this.token || '625D128F3DBA486AABE7CBA9BDF90E69' //'AF3DFCF2DD4B4115AC47ACA25D5420E9''F90DF48D3EFA49DFAE1267A67DBEFB18'//token
            let url = api + this.getUrlPara(para)
            return fetch({
                url: getApiUrl(url),
                method: 'get',
                data: para
            })
        },

        // 通用POST请求
        API_POST(api, para, callback) {
            para.token = para.token || this.token || '625D128F3DBA486AABE7CBA9BDF90E69' //'AF3DFCF2DD4B4115AC47ACA25D5420E9''F90DF48D3EFA49DFAE1267A67DBEFB18'//token
            return fetch({
                url: getApiUrl(api),
                method: 'post',
                data: para
            })
        },

        // 从html参数
        getUrlKey(name) {
            if (decodeURIComponent && location.href) {
                return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.href) || [, ""])[1].replace(/\+/g, '%20')) || null
            } else {
                return null
            }
        },
        getUrlSearch(url, name) {
            if (typeof name == 'undefined') {
                name = url
                url = location.href
            }
            var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
            var r = url.slice(url.indexOf('?') + 1).match(reg);
            if (r != null) {
                try {
                    return decodeURIComponent(r[2]);
                } catch (_e) {
                    return null
                }
            }
            return null
        },

    }
}
