const vueFilter = {
    dateFilter: (value) => {
        if (!value) return '';
        return new Date(value).format("yyyy-MM-dd hh:mm:ss");
    },
    getPushWay: (value) => {
        if (value == 1) {
            return '模板推送'
        } else if (value == 2) {
            return '手动推送'
        }
    },
    getPushStatus: (value) => {
        if (value == 1) {
            return '推送中'
        } else if (value == 2) {
            return '推送完成 '
        } else if (value == 3) {
            return '任务中断'
        }
    },
    getToValue: (value) => {
        let toValue = value.toCount + ' | ' + Math.round(value.toProportion*10000)/10000 + '%';
        return toValue;
    },
    getClickValue: (value) => {
        let clickValue = value.clickCount + ' | ' + Math.round(value.clickProportion*10000)/10000 + '%';
        return clickValue;
    },
    getFailedValue: (value) => {
        let failedValue = value.failedCount + ' | ' + Math.round(value.failedProportion*10000)/10000 + '%';
        return failedValue;
    },
    getNotice: (value) => {
        if (value == 1) {
            return '否'
        } else if (value == 2) {
            return '是'
        }
    },
}
export default vueFilter