import "@babel/polyfill";
import Vue from 'vue'
import VueRouter from 'vue-router'
import routes from './router/router'
import store from './store/'
const mixins = require('@/utils/mixins');
import FastClick from 'fastclick'
import vueFilters from '@/utils/filter'

// import './assets/utf8-jsp/ueditor.config.js'
// import './assets/utf8-jsp/ueditor.all.min.js'
// import './assets/utf8-jsp/lang/zh-cn/zh-cn.js'
// import './assets/utf8-jsp/ueditor.parse.min.js'

// 引入ElementUI
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css';

// 可调试
// Vue.config.devtools = true;
// Vue.use(Logger, { prefix: new Date(), isDev: process.env.NODE_ENV === 'development', cLevel: 'debug' })

Vue.use(ElementUI)

// 注册所有公用过滤器
for(let key in vueFilters) {
	Vue.filter(key, vueFilters[key])
}

if ('addEventListener' in document) {
    document.addEventListener('DOMContentLoaded', function() {
        FastClick.attach(document.body);
    }, false);
}

Vue.use(VueRouter)
const router = new VueRouter({
	routes,
	mode: 'hash',
	strict: process.env.NODE_ENV !== 'production',
	scrollBehavior (to, from, savedPosition) {
	    if (savedPosition) {
		    return savedPosition
		} else {
			if (from.meta.keepAlive) {
				from.meta.savedPosition = document.body.scrollTop;
			}
		    return { x: 0, y: to.meta.savedPosition || 0 }
		}
	}
})

// 加入混合
Vue.mixin({
	...mixins
})
new Vue({
	router,
	store,
}).$mount('#app')

