import App from '../App'

const blank = r => require.ensure([], () => r(require('../views/blank')), 'blank')

// 新增 协议管理
const protocolList = r => require.ensure([], () => r(require('../views/protocol/protocol-list.vue')), 'protocol-list');
const createProtocol = r => require.ensure([], () => r(require('../views/protocol/create-protocol.vue')), 'create-protocol');
const protocolHistory = r => require.ensure([], () => r(require('../views/protocol/protocol-history.vue')), 'protocol-history');
const protocolDetail = r => require.ensure([], () => r(require('../views/protocol/protocol-detail.vue')), 'protocol-detail');

export default [{
    path: '/',
    component: App,
    children: [
        {
            path: '',
            redirect: '/protocol-list'
        },{
            path: '/index',
            redirect: '/protocol-list'
        },{
            path: '/home',
            redirect: '/protocol-list'
        },{
            path: '/blank',
            component: blank
        },
        // {
        //     path: '/item-manager',
        //     component: itemManager
        // },{
        //     path: '/add-manager',
        //     component: addManager
        // },{
        //     path: '/item-component',
        //     component: itemComponent
        // },{
        //     path: '/role',
        //     component: roleManager
        // },{
        //     path: '/create-component',
        //     component: createComponent
        // },{
        //     path: '/item-role',
        //     component: itemRole
        // },{
        //     path: '/create-push',
        //     component: createPush
        // },{
        //     path: '/history-push',
        //     component: historyPush
        // },{
        //     path: '/strategy-manage',
        //     component: strategyManage
        // },{
        //     path: '/msg-history',
        //     component: msgHistory
        // },{
        //     path: '/blacklist',
        //     component: blacklist
        // },{
        //     path: '/fatigue-control',
        //     component: fatigueControl
        // },
        {
            path: '/protocol-list',
            component: protocolList
        },{
            path: '/create-protocol',
            component: createProtocol
        },{
            path: '/protocol-detail',
            component: protocolDetail
        },{
            path: '/protocol-history',
            component: protocolHistory
        }
    ]
}]