export default ($this) => {
  return [
    {
      formType: 'div',
      name: '1.2 调查时状态',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'investigationState',
      model: 'investigationState',
      spanNum: 24,
      label: '调查时状态：',
      options: [
        { label: '接受调查', value: '1' },
        { label: '失访', value: '2' },
        { label: '死亡', value: '3' }
      ],
      rules: [{ required: true, message: '请选择调查时状态', trigger: 'change' }],
      changeFun: (e)=>{

      }
    },

    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'investigationWay',
      model: 'investigationWay',
      label: '调查方式：',
      linkageRule: [{ name: 'investigationState', value: ['1'] }],
      disabled: false,
      placeholder: '150',
      spanNum: 24,
      options: [
        { label: '面对面', value: '面对面', disabled: false },
        { label: '电话（限中危人群，高危人群6个月随访）', value: '电话（限中危人群，高危人群6个月随访）', disabled: false },
      ],
      rules: [{ required: true, message: '请选择调查方式', trigger: 'change' }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'oneself',
      model: 'oneself',
      label: '本次调查是否为被调查者本人：',
      linkageRule: [{ name: 'investigationState', value: ['1'] }],
      disabled: false,
      placeholder: '150',
      spanNum: 24,
      options: [
        { label: '是', value: '1', disabled: false },
        { label: '否', value: '2', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title3',
      prop: 'relationship',
      model: 'relationship',
      label: '提供信息者与被调查者之间关系：',
      linkageRule: [{ name: 'oneself', value: ['2'] }],
      disabled: false,
      placeholder: '150',
      spanNum: 24,
      options: [
        { label: '父母', value: '1', disabled: false },
        { label: '配偶', value: '2', disabled: false },
        { label: '子女', value: '3', disabled: false },
        { label: '兄弟姐妹', value: '4', disabled: false },
        { label: '其他', value: '5', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }]
    },
    {
      formType: 'input',
      className: 'obj-form-title4',
      linkageRule: [{name: 'relationshipRemark',value: ['5']}],
      prop: 'relationshipRemark',
      model: 'relationshipRemark',
      disabled: false,
      placeholder: '请输入其他关系',
      spanNum: 12,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入其他关系', trigger: 'blur' }]
    },

    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'lossReason',
      model: 'lossReason',
      spanNum: 24,
      label: '失访原因：',
      linkageRule: [{ name: 'investigationState', value: ['2'] }],
      options: [
        { label: '失去联系', value: '1' },
        { label: '拒绝参加调查', value: '2' },
        { label: '其他', value: '3' }
      ],
      rules: [{ required: true, message: '请选择失访原因', trigger: 'change' }]
    },
    {
      formType: 'input',
      className: 'obj-form-title3',
      linkageRule: [{name: 'lossReason',value: ['3']}],
      prop: 'lossRemark',
      model: 'lossRemark',
      disabled: false,
      placeholder: '请输入其他失访原因',
      spanNum: 12,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入其他失访原因', trigger: 'blur' }]
    },


    {
      formType: 'date-picker',
      className: 'obj-form-title2',
      prop: 'deadTime',
      model: 'deadTime',
      placeholder: '选择死亡时间',
      label: '死亡时间：',
      linkageRule: [{ name: 'investigationState', value: ['3'] }],
      format: 'yyyy-MM-dd HH:mm',
      valueFormat: 'yyyy-MM-dd HH:mm',
      dateType: 'datetime',
      type: 'date',
      rules: [{ required: true, message: '请选择死亡时间', trigger: 'change' }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'causeOfDeath',
      model: 'causeOfDeath',
      label: '死亡原因：',
      linkageRule: [{ name: 'investigationState', value: ['3'] }],
      disabled: false,
      placeholder: '150',
      spanNum: 24,
      options: [
        { label: '脑卒中', value: '1', disabled: false },
        { label: '冠心病', value: '2', disabled: false },
        { label: '恶心肿瘤', value: '3', disabled: false },
        { label: '呼吸系统疾病', value: '4', disabled: false },
        { label: '损伤和中毒', value: '5', disabled: false },
        { label: '不祥', value: '6', disabled: false },
        { label: '其他', value: '7', disabled: false },
      ],
      rules: [{ required: true, message: '请选择死亡原因', trigger: 'change' }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title3',
      prop: 'deadStrokeRemark',
      model: 'deadStrokeRemark',
      label: '脑卒中类型：',
      linkageRule: [{ name: 'causeOfDeath', value: ['1'] }],
      disabled: false,
      placeholder: '150',
      spanNum: 24,
      options: [
        { label: '出血性脑卒中', value: '1', disabled: false },
        { label: '缺血性脑卒中', value: '2', disabled: false },
        { label: '不祥', value: '3', disabled: false },
      ],
      rules: [{ required: true, message: '请选择脑卒中类型', trigger: 'change' }]
    },
    {
      formType: 'input',
      className: 'obj-form-title3',
      linkageRule: [{name: 'causeOfDeath',value: ['7']}],
      prop: 'deadRemark',
      model: 'deadRemark',
      disabled: false,
      placeholder: '请输入其他死亡原因',
      spanNum: 12,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入其他死亡原因', trigger: 'blur' }]
    },

  ]
}

