export default ($this) => {
  return [
    {
      formType: 'div',
      name: '3.1 脑血管病',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'diseasedHappened',
      model: 'diseasedHappened',
      label: '随访期间有无新发脑血管病事件：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '无', value: '1', disabled: false },
        { label: '有', value: '2', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }]
    },
    {
      formType: 'input',
      className: 'obj-form-title2',
      linkageRule: [{name: 'diseasedHappened',value: ['2']}],
      prop: 'times',
      model: 'times',
      label: '发病次数：',
      disabled: false,
      placeholder: '请输入发病次数',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{ name: '次', type: 'append' }],
      rules: [{ required: true, message: '请输入发病次数', trigger: 'blur' }]
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title2',
      prop: 'firstTime',
      model: 'firstTime',
      placeholder: '请选择',
      label: '随访期间第一次发病时间：',
      linkageRule: [{ name: 'diseasedHappened', value: ['2'] }],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      rules: [{ required: true, message: '请选择随访期间第一次发病时间', trigger: 'change' }],
      spanNum: 24,
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'hospitalLevel',
      model: 'hospitalLevel',
      label: '就诊机构级别：',
      linkageRule: [{ name: 'diseasedHappened', value: ['2'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '省级医院', value: '1', disabled: false },
        { label: '地市级医院', value: '2', disabled: false },
        { label: '县级医院', value: '3', disabled: false },
        { label: '社区或乡镇卫生机构', value: '4', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'mainDiagnosis',
      model: 'mainDiagnosis',
      label: '主要诊断：',
      linkageRule: [{ name: 'diseasedHappened', value: ['2'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '脑梗死', value: '1', disabled: false },
        { label: '脑出血', value: '2', disabled: false },
        { label: '蛛网膜下腔出血', value: '3', disabled: false },
        { label: '短暂性脑缺血发作（TIA）', value: '4', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'beHospitalizedRecureTreat',
      model: 'beHospitalizedRecureTreat',
      label: '住院期间是否接受康复治疗：',
      linkageRule: [{ name: 'diseasedHappened', value: ['2'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '1', disabled: false },
        { label: '是', value: '2', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'leaveHospitalRecureTreat',
      model: 'leaveHospitalRecureTreat',
      label: '出院后是否接受康复治疗：',
      linkageRule: [{ name: 'diseasedHappened', value: ['2'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '1', disabled: false },
        { label: '是', value: '2', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }]
    },

  ]
}
