//求并集
export function getUnion(a,b){
  if(a.constructor === Array && b.constructor === Array){
      let set1 = new Set(a);
      let set2 = new Set(b);
      return Array.from(new Set([...set1,...set2]));
  }
  return null;
}
//求差集
export function getDifference(a,b){
  if(a.constructor === Array && b.constructor === Array){
      let set1 = new Set(a);
      let set2 = new Set(b);
      return Array.from(new Set([...set1].filter(x => !set2.has(x))));
  }
  return null;
}
//求交集
export function getIntersect(a,b){
  if(a.constructor === Array && b.constructor === Array){
      let set1 = new Set(a);
      let set2 = new Set(b);
      return Array.from(new Set([...set1].filter( x => set2.has(x))));
  }
  return null;
}
//获取id的list
export function getIdList(data) {
  let list = [];
  for(let i=0;i<data.length;i++) {
    list.push(data[i].id);
  }
  return list;
}
//区域
export function getAdministrative(data) {
  let list = data.split('|');
  //for(let i)
  console.log(list);
  return list
}
export function getLevelList(data) {
  let level = [];
  level[0] = {
    id: '0',
    label: '全部',
  }
  for (let i = 0; i < data.length; i++) {
    let obj = {
      id: data[i].no,
      label: data[i].value,
    }
    level.push(obj);
  }
  //console.log(level);
  return level;
}
function inTags(id,tags) {
  let flag = false;
  for(let i = 0;i<tags.length;i++) {
    if(tags[i].key == id) {
      flag = true;
    }
  }
  return flag;
}
export function inOrganization(list,id) {
  let flag = false;
  if(list.length == 0) {
    flag = true;
  }
  for(let i=0;i<list.length;i++) {
    if(list[i].id != id) {
      flag = true;
    }
  }
  return flag;
}
function recursiveTraverse (node,tags) {
  let afterTree = [];
  let add = 0;
	node.forEach(function(item, index) {
    let obj = {
      value: item.id,
      label: item.label,
    }
    if(inTags(item.id,tags)) {
      afterTree[add] = obj;
      add++;
    } else if(item.children.length > 0) {
      afterTree[add] = obj;
      afterTree[add].children = [];
      add++;
      let add2 = 0;
      item.children.forEach(function(item2, index2) {
        let obj = {
          value: item2.id,
          label: item2.label,
        }
        console.log(afterTree[add],add2)
        //afterTree[add].children[add2] = obj;
      });
    }
  });
  return afterTree;

}
//拼装选择的tree
export function getTreeData(data,tags) {
  console.log('allTree', data.children,'tags',tags);
  console.log(JSON.stringify(data.children));
  console.log(JSON.stringify(tags));

  let afterTree = recursiveTraverse(data.children,tags);
  console.log('afterTree ',afterTree);
  let options = [
    {
      value: 'zhinan',
      label: '指南',
      children: [{
        value: 'shejiyuanze',
        label: '设计原则',
        children: [{
          value: 'yizhi',
          label: '一致'
        }, {
          value: 'fankui',
          label: '反馈'
        }, {
          value: 'xiaolv',
          label: '效率'
        }, {
          value: 'kekong',
          label: '可控'
        }]
      }, {
        value: 'daohang',
        label: '导航',
        children: [{
          value: 'cexiangdaohang',
          label: '侧向导航'
        }, {
          value: 'dingbudaohang',
          label: '顶部导航'
        }]
      }]
    }, {
      value: 'zujian',
      label: '组件',
      children: [{
        value: 'basic',
        label: 'Basic',
        children: [{
          value: 'layout',
          label: 'Layout 布局'
        }, {
          value: 'color',
          label: 'Color 色彩'
        }, {
          value: 'typography',
          label: 'Typography 字体'
        }, {
          value: 'icon',
          label: 'Icon 图标'
        }, {
          value: 'button',
          label: 'Button 按钮'
        }]
      }, {
        value: 'form',
        label: 'Form',
        children: [{
          value: 'radio',
          label: 'Radio 单选框'
        }, {
          value: 'checkbox',
          label: 'Checkbox 多选框'
        }, {
          value: 'input',
          label: 'Input 输入框'
        }, {
          value: 'input-number',
          label: 'InputNumber 计数器'
        }, {
          value: 'select',
          label: 'Select 选择器'
        }, {
          value: 'cascader',
          label: 'Cascader 级联选择器'
        }, {
          value: 'switch',
          label: 'Switch 开关'
        }, {
          value: 'slider',
          label: 'Slider 滑块'
        }, {
          value: 'time-picker',
          label: 'TimePicker 时间选择器'
        }, {
          value: 'date-picker',
          label: 'DatePicker 日期选择器'
        }, {
          value: 'datetime-picker',
          label: 'DateTimePicker 日期时间选择器'
        }, {
          value: 'upload',
          label: 'Upload 上传'
        }, {
          value: 'rate',
          label: 'Rate 评分'
        }, {
          value: 'form',
          label: 'Form 表单'
        }]
      }, {
        value: 'data',
        label: 'Data',
        children: [{
          value: 'table',
          label: 'Table 表格'
        }, {
          value: 'tag',
          label: 'Tag 标签'
        }, {
          value: 'progress',
          label: 'Progress 进度条'
        }, {
          value: 'tree',
          label: 'Tree 树形控件'
        }, {
          value: 'pagination',
          label: 'Pagination 分页'
        }, {
          value: 'badge',
          label: 'Badge 标记'
        }]
      }, {
        value: 'notice',
        label: 'Notice',
        children: [{
          value: 'alert',
          label: 'Alert 警告'
        }, {
          value: 'loading',
          label: 'Loading 加载'
        }, {
          value: 'message',
          label: 'Message 消息提示'
        }, {
          value: 'message-box',
          label: 'MessageBox 弹框'
        }, {
          value: 'notification',
          label: 'Notification 通知'
        }]
      }, {
        value: 'navigation',
        label: 'Navigation',
        children: [{
          value: 'menu',
          label: 'NavMenu 导航菜单'
        }, {
          value: 'tabs',
          label: 'Tabs 标签页'
        }, {
          value: 'breadcrumb',
          label: 'Breadcrumb 面包屑'
        }, {
          value: 'dropdown',
          label: 'Dropdown 下拉菜单'
        }, {
          value: 'steps',
          label: 'Steps 步骤条'
        }]
      }, {
        value: 'others',
        label: 'Others',
        children: [{
          value: 'dialog',
          label: 'Dialog 对话框'
        }, {
          value: 'tooltip',
          label: 'Tooltip 文字提示'
        }, {
          value: 'popover',
          label: 'Popover 弹出框'
        }, {
          value: 'card',
          label: 'Card 卡片'
        }, {
          value: 'carousel',
          label: 'Carousel 走马灯'
        }, {
          value: 'collapse',
          label: 'Collapse 折叠面板'
        }]
      }]
    }, {
      value: 'ziyuan',
      label: '资源',
      children: [{
        value: 'axure',
        label: 'Axure Components'
      }, {
        value: 'sketch',
        label: 'Sketch Templates'
      }, {
        value: 'jiaohu',
        label: '组件交互文档'
      }]
    }];
  return afterTree;
}
export function organizationList(data) {
  let list = [];
  list[0] = {
    value: '0',
    label: '全部',
  };
  for(let i=0;i<data.length;i++) {
    let obj = {
      value: data[i].key,
      label: data[i].name,
    }
    list.push(obj);
  }
  return list;
}