const followUp = r => require.ensure([], () => r(require('../views/followup/layout.vue')), 'followUp');

const planManage = r => require.ensure([], () => r(require('../views/followup/planManage/layout.vue')), 'planManage');
const planList = r => require.ensure([], () => r(require('../views/followup/planManage/plan-list.vue')), 'planList');

const reservationManage = r => require.ensure([], () => r(require('../views/followup/reservationManage/layout.vue')), 'reservationManage');
const reservationList = r => require.ensure([], () => r(require('../views/followup/reservationManage/reservation-list.vue')), 'reservationList');


const recordManage = r => require.ensure([], () => r(require('../views/followup/recordManage/layout.vue')), 'recordManage');
const recordList = r => require.ensure([], () => r(require('../views/followup/recordManage/record-list.vue')), 'recordList');



const followRouters = {
    path: '/followUp',
    name: 'followUp',
    component: followUp,
    redirect: 'followUp/plan/planList',
    children: [
      {
        path: 'planManage',
        component: planManage,
        name: 'planManage',
        redirect: 'planManage/planList',
        children: [
          {
            path: 'planList',
            component: planList,
            name: 'planList',
            meta: {
              title: '计划列表',
            },
          },
        ],
        meta: {
          title: '计划管理',
        },
      },
      {
        path: 'reservationManage',
        component: reservationManage,
        name: 'reservationManage',
        redirect: 'reservationManage/reservationList',
        children: [
          {
            path: 'reservationList',
            component: reservationList,
            name: 'reservationList',
            meta: {
              title: '预约列表',
            },
          },
        ],
        meta: {
          title: '预约管理',
        },
      },
      {
        path: 'recordManage',
        component: recordManage,
        name: 'recordManage',
        redirect: 'recordManage/recordList',
        children: [
          {
            path: 'recordList',
            component: recordList,
            name: 'recordList',
            meta: {
              title: '录入列表',
            },
          },
        ],
        meta: {
          title: '录入管理',
        },
      },

    ],
  };

export default followRouters
