import fetch from "../fetch";
import { getBaseUrl } from "@/utils/index";
let headers = {
  "Content-Type": "application/json;charset=UTF-8",
  token: localStorage.getItem("storageToken"),
};

/*获取省份*/
export const getProvinces = () => {
  return fetch({
    headers,
    url: getBaseUrl(`/basic-data/position/provinces`),
    method: "get",
  });
};

// /*获取市*/
export const getCities = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`/basic-data/position/cities`),
    method: "get",
    params: params,
  });
};

// /*获取区*/
export const getCounties = (params) => {
  return fetch({
    url: getBaseUrl(`/basic-data/position/counties`),
    method: "get",
    params: params,
  });
};

// /*获取乡镇*/
export const getTowns = (params) => {
  return fetch({
    url: getBaseUrl(`/basic-data/position/towns`),
    method: "get",
    params: params,
  });
};
