import { checkRange, checkIsInteger, checkNumberIsToFixed, checkNumberIsToFixedTwo } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  let hanldeValueL = () => {
    $this.addComponents.forEach((item,index)=>{
      if(item.name == 'diabetesSourseAuxiliary'){
        const fastingBloodSugar = item.formObject.fastingBloodSugar
        const glycosylatedHemoglobinPercent = item.formObject.glycosylatedHemoglobinPercent
        const glycosylatedHemoglobinDate = item.formObject.glycosylatedHemoglobinDate
        item.dataSource.forEach((item2,index2)=>{
          if((glycosylatedHemoglobinPercent||glycosylatedHemoglobinDate)){
            if(item2.rules){
              $this.addComponents[index].dataSource[index2].rules[0].required = true;
            }
          }else{
            console.log('当选填项都没值时',item2)
            if(item2.prop == 'fastingBloodSugar'){
              $this.addComponents[index].dataSource[index2].rules[0].required = true;
            }else {
              $this.addComponents[index].dataSource[index2].rules[0].required = false;
            }
          }
        })
      }
      $this.$refs['form'+index][0].validate((valid) => {
      });
    })
  }
  return [
    {
      formType: 'input',
      className: 'float-none',
      prop: 'fastingBloodSugar',
      model: 'fastingBloodSugar',
      disabled: false,
      label: '空腹血糖值：',
      placeholder: '请输入空腹血糖值',
      spanNum: 6,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{name: 'mmol/L', type: 'append'}],
      rules: [{ required: true, message: '请输入空腹血糖值', trigger: ['submit','change'] },{ validator: checkRange , trigger: ['submit','change'] },{ validator: checkNumberIsToFixed , trigger: ['submit','change'] }]
    },
    // {
    //   formType: 'div',
    //   name: '其他检查',
    //   className: 'sec-title',
    // },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'glycosylatedHemoglobinPercent',
      model: 'glycosylatedHemoglobinPercent',
      disabled: false,
      label: '糖化血红蛋白值：',
      placeholder: '请输入糖化血红蛋白值',
      spanNum: 6,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{name: '%', type: 'append'}],
      rules: [{ required: false, message: '请输入糖化血红蛋白值', trigger: ['submit','change','blur'] },{ validator: checkRange , trigger: ['submit','change','blur'] },{ validator: checkNumberIsToFixedTwo , trigger: ['submit','change','blur'] }],
      changeFun: hanldeValueL,
      blurFunc: hanldeValueL
    },
    {
      formType: 'date-picker',
      className: 'float-none',
      prop: 'glycosylatedHemoglobinDate',
      model: 'glycosylatedHemoglobinDate',
      placeholder: '请选择',
      label: '检查日期：',
      format: 'MM 月 dd 日',
      valueFormat: 'MM-dd',
      dateType: 'date',
      type: 'date',
      rules: [{required: false, message: '请选择检查日期', trigger: ['submit','change']}],
      spanNum: 12,
      changeFun: hanldeValueL
    },
  ]
}

