export default ($this) => {
  return [
    {
      formType: 'div',
      name: '1.2 调查时状态',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title margin-left-20',
      prop: 'investigationState',
      model: 'investigationState',
      spanNum: 24,
      label: '调查时状态：',
      options: [
        { label: '接受调查', value: '接受调查' },
        { label: '失访', value: '失访' },
        { label: '死亡', value: '死亡' }
      ],
      rules: [{ required: true, message: '请选择调查时状态', trigger: ['submit','change'] }],
      changeFun: (e)=>{
        console.log(e)
        if(e == '失访' || e=='死亡'){
          $this.showModule = false;
        }else{
          $this.showModule = true;
        }

      }
    },

    {
      formType: 'radio',
      className: 'obj-form-title2 margin-left-40',
      prop: 'investigationWay',
      model: 'investigationWay',
      label: '调查方式：',
      linkageRule: [{ name: 'investigationState', value: ['接受调查'] }],
      disabled: false,
      placeholder: '150',
      spanNum: 24,
      options: [
        { label: '面对面', value: '面对面', disabled: false },
        { label: '电话（限中危人群，高危人群6个月随访）', value: '电话（限中危人群，高危人群6个月随访）', disabled: false },
      ],
      rules: [{ required: true, message: '请选择调查方式', trigger: ['submit','change'] }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2 margin-left-40',
      prop: 'oneself',
      model: 'oneself',
      label: '本次调查是否为被调查者本人：',
      linkageRule: [{ name: 'investigationState', value: ['接受调查'] }],
      disabled: false,
      placeholder: '150',
      spanNum: 24,
      options: [
        { label: '是', value: '是', disabled: false },
        { label: '否', value: '否', disabled: false },
      ],
      rules: [{ required: true, message: '请选择本次调查是否为被调查者本人', trigger: ['submit','change'] }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title3 margin-left-60',
      prop: 'relationship',
      model: 'relationship',
      label: '提供信息者与被调查者之间关系：',
      linkageRule: [{ name: 'oneself', value: ['否'] }],
      disabled: false,
      placeholder: '150',
      spanNum: 24,
      options: [
        { label: '父母', value: '父母', disabled: false },
        { label: '配偶', value: '配偶', disabled: false },
        { label: '子女', value: '子女', disabled: false },
        { label: '兄弟姐妹', value: '兄弟姐妹', disabled: false },
        { label: '其他', value: '其他', disabled: false },
      ],
      rules: [{ required: true, message: '请选择提供信息者与被调查者之间关系', trigger: ['submit','change'] }]
    },
    {
      formType: 'input',
      className: 'obj-form-title4 margin-left-80',
      linkageRule: [{name: 'relationship',value: ['其他']}],
      prop: 'relationshipRemark',
      model: 'relationshipRemark',
      disabled: false,
      placeholder: '请输入其他关系',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入其他关系', trigger: ['submit','change'] }]
    },

    {
      formType: 'radio',
      className: 'obj-form-title3 margin-left-60',
      prop: 'lossReason',
      model: 'lossReason',
      spanNum: 24,
      label: '失访原因：',
      linkageRule: [{ name: 'investigationState', value: ['失访'] }],
      options: [
        { label: '失去联系', value: '失去联系' },
        { label: '拒绝参加调查', value: '拒绝参加调查' },
        { label: '其他', value: '其他' }
      ],
      rules: [{ required: true, message: '请选择失访原因', trigger: ['submit','change'] }]
    },
    {
      formType: 'input',
      className: 'obj-form-title3 margin-left-60',
      linkageRule: [{name: 'lossReason',value: ['其他']}],
      prop: 'lossRemark',
      model: 'lossRemark',
      disabled: false,
      placeholder: '请输入其他失访原因',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入其他失访原因', trigger: ['submit','change'] }]
    },


    {
      formType: 'date-picker',
      className: 'obj-form-title2 margin-left-40',
      prop: 'deadTime',
      model: 'deadTime',
      placeholder: '选择死亡时间',
      label: '死亡时间：',
      linkageRule: [{ name: 'investigationState', value: ['死亡'] }],
      format: 'yyyy-MM-dd HH:mm',
      valueFormat: 'yyyy-MM-dd HH:mm',
      dateType: 'datetime',
      type: 'date',
      spanNum: 12,
      rules: [{ required: true, message: '请选择死亡时间', trigger: ['submit','change'] }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2 margin-left-40',
      prop: 'causeOfDeath',
      model: 'causeOfDeath',
      label: '死亡原因：',
      linkageRule: [{ name: 'investigationState', value: ['死亡'] }],
      disabled: false,
      placeholder: '150',
      spanNum: 24,
      options: [
        { label: '脑卒中', value: '脑卒中', disabled: false },
        { label: '冠心病', value: '冠心病', disabled: false },
        { label: '恶性肿瘤', value: '恶性肿瘤', disabled: false },
        { label: '呼吸系统疾病', value: '呼吸系统疾病', disabled: false },
        { label: '损伤和中毒', value: '损伤和中毒', disabled: false },
        { label: '不祥', value: '不祥', disabled: false },
        { label: '其他', value: '其他', disabled: false },
      ],
      rules: [{ required: true, message: '请选择死亡原因', trigger: ['submit','change'] }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title3 margin-left-60',
      prop: 'deadStrokeRemark',
      model: 'deadStrokeRemark',
      label: '脑卒中类型：',
      linkageRule: [{ name: 'causeOfDeath', value: ['脑卒中'] }],
      disabled: false,
      placeholder: '150',
      spanNum: 24,
      options: [
        { label: '出血性脑卒中', value: '出血性脑卒中', disabled: false },
        { label: '缺血性脑卒中', value: '缺血性脑卒中', disabled: false },
        { label: '不祥', value: '不祥', disabled: false },
      ],
      rules: [{ required: true, message: '请选择脑卒中类型', trigger: ['submit','change'] }]
    },
    {
      formType: 'input',
      className: 'obj-form-title3 margin-left-60',
      linkageRule: [{name: 'causeOfDeath',value: ['其他']}],
      prop: 'deadRemark',
      model: 'deadRemark',
      disabled: false,
      placeholder: '请输入其他死亡原因',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入其他死亡原因', trigger: ['submit','change'] }]
    },

  ]
}

