import { checkRange } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  return [
    {
      formType: 'div',
      name: '6.1 血糖',
      className: 'sec-title',
    },
    {
      formType: 'date-picker',
      className: 'float-none',
      prop: 'inspectTime',
      model: 'inspectTime',
      placeholder: '请选择',
      label: '检查时间：',
      format: 'yyyy-MM-dd',
      valueFormat: 'yyyy-MM-dd',
      dateType: 'date',
      type: 'date',
      rules: [{required: true, message: '检查时间', trigger: 'submit'}],
      spanNum: 6,
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'fastingBloodGlucose',
      model: 'fastingBloodGlucose',
      label: '空腹血糖：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmol/L', type: 'append'}],
      rules: [{required: true, message: '请输入空腹血糖', trigger: 'submit'},{ validator: checkRange , trigger: 'submit' }],
    },


    {
      formType: 'div',
      name: '6.2 血脂',
      className: 'sec-title',
    },
    {
      formType: 'date-picker',
      className: 'float-none',
      prop: 'inspectTime1',
      model: 'inspectTime1',
      placeholder: '请选择',
      label: '检查时间：',
      format: 'yyyy-MM-dd',
      valueFormat: 'yyyy-MM-dd',
      dateType: 'date',
      type: 'date',
      rules: [{required: true, message: '检查时间', trigger: 'submit'}],
      spanNum: 6,
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'triglyceride',
      model: 'triglyceride',
      label: '甘油三酯：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmol/L', type: 'append'}],
      rules: [{required: true, message: '请输入甘油三酯', trigger: 'submit'},{ validator: checkRange , trigger: 'submit' }],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'cholesterol',
      model: 'cholesterol',
      label: '胆固醇：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmol/L', type: 'append'}],
      rules: [{required: true, message: '请输入胆固醇', trigger: 'submit'},{ validator: checkRange , trigger: 'submit' }],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'cLdl',
      model: 'cLdl',
      label: '低密度脂蛋白胆固醇：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmol/L', type: 'append'}],
      rules: [{required: true, message: '请输入低密度脂蛋白胆固醇', trigger: 'submit'},{ validator: checkRange , trigger: 'submit' }],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'cHdl',
      model: 'cHdl',
      label: '高密度脂蛋白胆固醇',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmol/L', type: 'append'}],
      rules: [{required: true, message: '请输入高密度脂蛋白胆固醇', trigger: 'submit'},{ validator: checkRange , trigger: 'submit' }],
    },
  ]
}
