import App from '../App'

const login = r => require.ensure([], () => r(require('../views/login')), 'login')

const home = r => require.ensure([], () => r(require('../views/home')), 'home')
const blank = r => require.ensure([], () => r(require('../views/blank')), 'blank')
const itemManager = r => require.ensure([], () => r(require('../views/education/item-manager.vue')), 'item-manager')
const itemComponent = r => require.ensure([], () => r(require('../views/education/item-component.vue')), 'item-component')
const createComponent = r => require.ensure([], () => r(require('../views/education/create-component.vue')),'create-component')
const roleManager = r => require.ensure([], () => r(require('../views/system/role.vue')),'role')
const addManager = r => require.ensure([], () => r(require('../views/education/add-manager.vue')), 'add-manager')
const editManager = r => require.ensure([], () => r(require('../views/education/edit-manager.vue')), 'edit-manager')
const itemRole = r => require.ensure([], () => r(require('../views/system/item-role.vue')), 'item-role')
const msgPush = r => require.ensure([], () => r(require('../views/msgpush/msg-push.vue')), 'msg-push')
const editCme = r => require.ensure([], () => r(require('../views/education/edit-cme.vue')), 'edit-cme')

import patientsRouters from './patients'
import followRouters from './follow'

const reportLisOld = r => require.ensure([], () => r(require('../views/learning-o/report-list.vue')), 'report-list-old')
const itemListOld = r => require.ensure([], () => r(require('../views/learning-o/item-list.vue')), 'item-list-old')
const nameListOld = r => require.ensure([], () => r(require('../views/learning-o/name-list.vue')), 'name-list-old')
const dataAlignmentOld = r => require.ensure([], () => r(require('../views/learning-o/data-alignment.vue')), 'data-alignment-old')
const exportDownloadOld = r => require.ensure([], () => r(require('../views/learning-o/export-download.vue')), 'export-download-old')

const reportLis = r => require.ensure([], () => r(require('../views/learning/report-list.vue')), 'report-list')
const itemList = r => require.ensure([], () => r(require('../views/learning/item-list.vue')), 'item-list')
const nameList = r => require.ensure([], () => r(require('../views/learning/name-list.vue')), 'name-list')
const dataAlignment = r => require.ensure([], () => r(require('../views/learning/data-alignment.vue')), 'data-alignment')
const exportDownload = r => require.ensure([], () => r(require('../views/learning/export-download.vue')), 'export-download')

const itemShield = r => require.ensure([], () => r(require('../views/education/item-shield.vue')), 'item-shield')
const entryManager = r => require.ensure([], () => r(require('../views/education/entry-manager.vue')), 'entry-manager')
const editEntry = r => require.ensure([], () => r(require('../views/education/edit-entry.vue')), 'edit-entry')
const editNotice = r => require.ensure([], () => r(require('../views/education/edit-notice.vue')), 'edit-notice')

const creditManage = r => require.ensure([], () => r(require('../views/cme/credit-manage.vue')), 'credit-manage')
const reviewAccessManage = r => require.ensure([], () => r(require('../views/cme/review-access-manage.vue')), 'review-access-manage')
const creditSendManage = r => require.ensure([], () => r(require('../views/cme/credit-send-manage.vue')), 'credit-send-manage')
const applyDetail =  r => require.ensure([], () => r(require('../views/cme/apply-detail.vue')), 'apply-detail')


const templateManager = r => require.ensure([], () => r(require('../views/education/template-manager.vue')), 'ctemplate-manager')
const templateEditor = r => require.ensure([], () => r(require('../views/education/template-editor.vue')), 'template-editor')
const templateOpen = r => require.ensure([], () => r(require('../views/education/template-open.vue')), 'templateOpen')
const eduRole = r => require.ensure([], () => r(require('../views/education/edu-role.vue')), 'edu-role')
const editCustom = r => require.ensure([], () => r(require('../views/education/edit-custom.vue')), 'templateOpen')
const externalResourceManage = r => require.ensure([], () => r(require('../views/education/external-resource-manage.vue')), 'external-resource-manage')
const auditCustomCourse = r => require.ensure([], () => r(require('../views/education/audit-custom-course.vue')), 'audit-custom-course')
const advertSimpleManage = r => require.ensure([], () => r(require('../views/education/advert-simple-manage.vue')), 'advert-simple-manage')
const editSimpleManage = r => require.ensure([], () => r(require('../views/education/edit-simple-manage.vue')), 'edit-simple-manage')


const noticeEditor = r => require.ensure([], () => r(require('../views/education/notice-editor.vue')), 'notice-editor')

const yqRange = r => require.ensure([], () => r(require('../views/yqrange/yq-range.vue')), 'yq-range')
const liveManage = r => require.ensure([], () => r(require('../views/yqrange/live-manage.vue')), 'live-manage')
const roleManage = r => require.ensure([], () => r(require('../views/yqrange/role-manage.vue')), 'role-manage')
const createRange = r => require.ensure([], () => r(require('../views/yqrange/create-range.vue')), 'create-range')
const editRange = r => require.ensure([], () => r(require('../views/yqrange/edit-range.vue')), 'edit-range')
const createLive = r => require.ensure([], () => r(require('../views/yqrange/create-live.vue')), 'create-live')

export default [{
    path: '/',
    component: App,
    children: [
        {
          path: '/login',
          component: login,
          name: 'loginPage',
        },
        {
            path: '',
            redirect: '/home'
        },{
            path: '/index',
            component: home
        },{
            path: '/home',
            component: home
        },{
            path: '/blank',
            component: blank
        },{
            path: '/item-manager',
            component: itemManager
        },{
            path: '/add-manager',
            component: addManager
        },{
            path: '/edit-manager',
            component: editManager
        },{
            path: '/edit-cme',
            component: editCme
        },{
            path: '/item-component',
            component: itemComponent
        },{
            path: '/role',
            component: roleManager
        },{
            path: '/create-component',
            component: createComponent
        },{
            path: '/item-role',
            component: itemRole
        }
        ,{
            path: '/report-list',
            component: reportLis
        },{
            path: '/item-list',
            component: itemList
        },{
            path: '/data-alignment',
            component: dataAlignment
        },{
            path: '/name-list',
            component: nameList
        },
        {
            path: '/export-download',
            component: exportDownload
        },

        {
            path: '/report-list-old',
            component: reportLisOld
        },{
            path: '/item-list-old',
            component: itemListOld
        },{
            path: '/data-alignment-old',
            component: dataAlignmentOld
        },{
            path: '/name-list-old',
            component: nameListOld
        },
        {
            path: '/export-download-old',
            component: exportDownloadOld
        },

        {
            path: '/item-shield',
            component: itemShield,
        },
        {
            path: '/entry-manager',
            component: entryManager,
        },
        {
            path: '/edit-entry',
            component: editEntry,
        },
        {
            path: '/msg-push',
            component: msgPush,
            // redirect: 'msgpush/msg-push',
        },
        {
            path: '/edit-notice',
            component: editNotice,
            // redirect: 'msgpush/msg-push',
        },
        {
            path: '/credit-manage',
            component: creditManage,
        },
        {
            path: '/review-access-manage',
            component: reviewAccessManage,
        },
        {
            path: '/credit-send-manage',
            component: creditSendManage,
        },
        {
            path: '/apply-detail',
            component: applyDetail,
        },
        {
            path: '/template-manager',
            component: templateManager
        },
        {
            path: '/template-editor',
            component: templateEditor
        },
        {
            path: '/template-open',
            component: templateOpen
        },
        {
            path: '/edit-custom',
            component: editCustom
        },
        {
            path: '/edu-role',
            component: eduRole
        },
        {
            path: '/notice-editor',
            component: noticeEditor
        },
        {
            path: '/yq-range',
            component: yqRange
        },
        {
            path: '/live-manage',
            component: liveManage
        },
        {
            path: '/role-manage',
            component: roleManage
        },
        {
            path: '/create-range',
            component: createRange
        },
        {
            path: '/create-live',
            component: createLive
        },
        {
            path:'/edit-range',
            component: editRange
        },
        {
            path: '/external-resource-manage',
            component: externalResourceManage,
        },
        {
            path: '/audit-custom-course',
            component: auditCustomCourse,
        },
        {
            path: '/advert-simple-manage',
            component: advertSimpleManage,
        },
        {
            path: '/edit-simple-manage',
            component: editSimpleManage,
        },
      // {
      //   path: '/followup',
      //   name: 'followUp',
      //   component: followUp,
      //   redirect: 'followup/plan-manage/planList',
      // },
        followRouters,
        patientsRouters,
    ]
  }]
