import "@babel/polyfill";
import Vue from 'vue'
import VueRouter from 'vue-router'
import routes from './router/router'
import store from './store/'
const mixins = require('@/utils/mixins');
import '@/utils/rem'					// 引入自适应
import '@/utils/yqyServerRegister'		// 移动端服务
import FastClick from 'fastclick'
import Logger from './plugins/logger' 	// 日志插件
import Swiper from './plugins/swiper.min.js' 	// 日志插件

// 引入Mint
import Mint from 'mint-ui'
import 'mint-ui/lib/style.css'

import VueLazyload from 'vue-lazyload'
Vue.use(VueLazyload, {
	preLoad: 3,
	// loading: 'images/change.png',
	// error: 'https://file.yunqueyi.com/File/course_doctor/2018-11/20/web_454.png',
	error: require('./images/error.png'),
	attempt: 1
	// lazyComponent: true
})

Vue.filter('yLocalString', function(value){
	var b = parseInt(value).toString();
	if (b === 'NaN') return 0;
	var len = b.length;
	if (len <= 3) { return b; }
	var r = len % 3;
	return r > 0 ? b.slice(0, r) + "," + b.slice(r, len).match(/\d{3}/g).join(",") : b.slice(r, len).match(/\d{3}/g).join(",");
})
Vue.filter('formatNumber', function(num, precision, separator) {
    var parts;
    if (!isNaN(parseFloat(num)) && isFinite(num)) {
        num = Number(num);
        num = (typeof precision !== 'undefined' ? num.toFixed(precision) : num).toString();
        parts = num.split('.');
        parts[0] = parts[0].toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1' + (separator || ','));
        return parts.join('.');
    }
    return '';
})

// 可调试
Vue.config.devtools = true;
Vue.use(Mint)
Vue.use(Logger, { prefix: new Date(), isDev: process.env.NODE_ENV === 'development', cLevel: 'debug' })

if ('addEventListener' in document) {
    document.addEventListener('DOMContentLoaded', function() {
        FastClick.attach(document.body);
    }, false);
}

Vue.use(VueRouter)
const router = new VueRouter({
	routes,
	mode: 'hash',
	strict: process.env.NODE_ENV !== 'production',
	scrollBehavior (to, from, savedPosition) {
	    if (savedPosition) {
		    return savedPosition
		} else {
			if (from.meta.keepAlive) {
				from.meta.savedPosition = document.body.scrollTop;
			}
		    return { x: 0, y: to.meta.savedPosition || 0 }
		}
	}
})

// 加入混合
Vue.mixin({
	...mixins
})
new Vue({
	router,
	store,
}).$mount('#app')

