import { formatTime } from './index'

const vueFilter = {
  // 通用状态过滤器
  formatStatus: function(value) {
    return !value ? '正常' : '停用'
  },

   formatNumber: function(num, precision, separator) {
    var parts;
    if (!isNaN(parseFloat(num)) && isFinite(num)) {
        num = Number(num);
        num = (typeof precision !== 'undefined' ? num.toFixed(precision) : num).toString();
        parts = num.split('.');
        parts[0] = parts[0].toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1' + (separator || ','));
        return parts.join('.');
    }
    return '';
  }
}

export default vueFilter
