import fetch from '../fetch';
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token: localStorage.getItem('storageToken'),
};


export const getAuth = () => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/user/auth`),
    method: 'get',
    description: '查看外部用户权限接口',
  })
};

export const getRangeList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/list`),
    method: 'post',
    data: params,
    description: '查看圈子列表',
  })
};

export const getCircleSettingList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/app/${params.circleId}/list`),
    method: 'get',
    description: '查看生态圈应用配置',
  })
};

export const saveCircleSetting = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/app/save`),
    method: 'post',
    data: params,
    description: '保存生态圈应用配置',
  })
};

export const downloadSigninfo = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`rtc/liveAdmin/download/signInfo/${params.rtcId}`),
    method: 'get',
    description: '下载签到信息表'
  })
};

export const updateRangeStatus = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/change/${params.id}/status/to/${params.status}`),
    method: 'get',
    description: '查询单个直播',
  })
};

export const getRtcInfo = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`rtc/liveAdmin/${params.rtcId}`),
    method: 'get',
    description: '查询单个直播',
  })
};

// 查询回放信息
export const getPlayback = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`rtc/liveAdmin/playback/${params.rtcId}`),
    method: 'get',
    description: '查询回放信息',
  })
};

export const postPlayback = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`rtc/liveAdmin/playback`),
    method: 'post',
    data: params,
    description: '设置/关闭回放',
  })
};

export const updateLiveStatus = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`rtc/liveAdmin/switchLiveStatus`),
    method: 'put',
    data: params,
    description: '更新直播状态',
  })
};


export const getImages = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`rtc/liveAdmin/backgroundImage`),
    method: 'get',
    description: '查询可用背景图',
  })
};

export const uploadOrg = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/import/hospitals`),
    method: 'post',
    data: params,
    description: '批量导入机构',
  })
};

export const uploadDoc = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/import/doctors`),
    method: 'post',
    data: params,
    description: '批量导入人员',
  })
};


export const searchDoc = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/doctor/search?circleId=${params.id}&name=${params.name}`),
    method: 'get',
    description: '直播搜索主播或者嘉宾',
  })
};

export const applyList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/apply/list`),
    method: 'post',
    data: params,
    description: '圈子审核列表',
  })
};

export const applyUpdate = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/apply/update`),
    method: 'post',
    data: params,
    description: '圈子审核列表更新',
  })
};

export const getCircleDept = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/judge/menu/${params.type}`),
    method: 'get',
    data: params,
    description: '参数为类型目前2为是否有圈子设置所属部门的权限,返回结果为true/false',
  })
};

export const getCircleAds = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/ad/${params.circleId}`),
    method: 'get',
    data: params,
    description: '查询广告栏位信息',
  })
};

export const saveCircleAds = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/ad/save`),
    method: 'post',
    data: params,
    description: 'B端保存广告栏位信息',
  })
};

export const getLinkType = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`contents/commonComstant/selectByTypeCode?code=${params.code}`),
    method: 'get',
    data: params,
    description: '获取链接类型下拉数据',
  })
};

export const getModuleData = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`contents/moduleConfig/selectName`),
    method: 'get',
    data: params,
    description: '获取模块下拉数据',
  })
};


export const getParamData = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`contents/moduleConfig/selectParam?id=${params.id}`),
    method: 'get',
    data: params,
    description: '获取参数下拉数据',
  })
};

export const getRankConfig = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/rank/config?circleId=${params.circleId}`),
    method: 'get',
    data: params,
    description: '获取排行榜配置',
  })
};



export const saveRankConfig = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/rank/save`),
    method: 'post',
    data: params,
    description: '保存排行榜配置',
  })
};


