import { checkRange, checkIsInteger, checkNumberIsToFixed } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  return [
    {
      formType: 'input',
      className: 'float-none',
      prop: 'systolicBloodPressure',
      model: 'systolicBloodPressure',
      label: '收缩压SBP：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 8,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmHg', type: 'append'}],
      rules: [{required: true, message: '请输入收缩压SBP', trigger: ['submit','change']},{ validator: checkRange , trigger: ['submit','change'] },{ validator: checkIsInteger , trigger: ['submit','change'] }],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'diastolicBloodPressure',
      model: 'diastolicBloodPressure',
      label: '舒张压DBP：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 8,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmHg', type: 'append'}],
      rules: [{required: true, message: '请输入舒张压DBP', trigger: ['submit','change']},{ validator: checkRange , trigger: ['submit','change'] },{ validator: checkIsInteger , trigger: ['submit','change'] }],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'bodyHeight',
      model: 'bodyHeight',
      label: '身高：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 8,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'cm', type: 'append'}],
      rules: [{required: true, message: '请输入身高', trigger: ['submit','change']},{ validator: checkRange , trigger: ['submit','change'] }, {validator: checkNumberIsToFixed , trigger: ['submit','change']}],
      changeFun: (val)=>{
        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'hypeDataSourceSign'){
            $this.addComponents[index].formObject.bodyHeight = val;
          }
        })
      },
      blurFunc: ()=>{
        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'hypeDataSourceSign'){
            let bodyWeight = $this.addComponents[index].formObject.bodyWeight
            let bodyHeight = $this.addComponents[index].formObject.bodyHeight
            if(bodyWeight && bodyHeight){
              bodyWeight = parseFloat(bodyWeight);
              bodyHeight = parseFloat(bodyHeight);
              let bmi = (bodyWeight / Math.pow((bodyHeight/100),2)).toFixed(1);
              $this.addComponents[index].formObject.bmi = bmi;
            }
          }
        })
      }
    },
    // 体质指数（BMI）=体重（kg）÷ 身高²（m）
    {
      formType: 'input',
      className: 'float-none',
      prop: 'bodyWeight',
      model: 'bodyWeight',
      label: '体重：',
      disabled: false,
      placeholder: '请输入（体重可以带1位小数点）',
      spanNum: 8,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'kg', type: 'append'}],
      rules: [{required: true, message: '请输入体重', trigger: ['submit','change']},{ validator: checkRange , trigger: ['submit','change'] }, {validator: checkNumberIsToFixed , trigger: ['submit','change']}],
      changeFun: (val)=>{
        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'hypeDataSourceSign'){
            $this.addComponents[index].formObject.bodyWeight = val;
          }
        })
      },
      blurFunc: ()=>{
        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'hypeDataSourceSign'){
            let bodyWeight = $this.addComponents[index].formObject.bodyWeight
            let bodyHeight = $this.addComponents[index].formObject.bodyHeight
            if(bodyWeight && bodyHeight){
              bodyWeight = parseFloat(bodyWeight);
              bodyHeight = parseFloat(bodyHeight);
              let bmi = (bodyWeight / Math.pow((bodyHeight/100),2)).toFixed(1);
              $this.addComponents[index].formObject.bmi = bmi;
            }
          }
        })
      }
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'bmi',
      model: 'bmi',
      label: 'BMI（系统自动生成）：',
      disabled: true,
      placeholder: '（这里是自动计算所得）',
      spanNum: 8,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'kg/m^2', type: 'append'}],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'nextBodyWeight',
      model: 'nextBodyWeight',
      label: '下次随访体重：',
      disabled: false,
      placeholder: '请输入（体重可以带1位小数点）',
      spanNum: 8,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'kg', type: 'append'}],
      rules: [{required: true, message: '请输入下次随访体重', trigger: ['submit','change']},{ validator: checkRange , trigger: ['submit','change'] }, {validator: checkNumberIsToFixed , trigger: ['submit','change']}],
      changeFun: (val)=>{
        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'hypeDataSourceSign'){
            $this.addComponents[index].formObject.nextBodyWeight = val;
          }
        })
      },
      blurFunc: ()=>{
        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'hypeDataSourceSign'){
            let nextBodyWeight = $this.addComponents[index].formObject.nextBodyWeight
            let bodyHeight = $this.addComponents[index].formObject.bodyHeight
            if(nextBodyWeight && bodyHeight){
              nextBodyWeight = parseFloat(nextBodyWeight);
              bodyHeight = parseFloat(bodyHeight);
              let nextBmi = (nextBodyWeight / Math.pow((bodyHeight/100),2)).toFixed(1);
              $this.addComponents[index].formObject.nextBmi = nextBmi;
            }
          }
        })
      }
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'nextBmi',
      model: 'nextBmi',
      label: '下次随访BMI（系统自动生成）：',
      disabled: true,
      placeholder: '（这里是自动计算所得）',
      spanNum: 8,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'kg/m^2', type: 'append'}],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'heartRate',
      model: 'heartRate',
      label: '心率：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 8,
      type: 'number',
      labmsg: '次',
      slots: [{name: '次/分', type: 'append'}],
      rules: [{required: true, message: '请输入心率', trigger: ['submit','change']},{ validator: checkRange , trigger: ['submit','change'] },{ validator: checkIsInteger , trigger: ['submit','change'] }],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'remark',
      model: 'remark',
      disabled: false,
      label: '其他',
      placeholder: '请输入其他体征',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [{ required: false, message: '请输入其他体征', trigger: ['submit','change'] }]
    },
  ]
}

