export default ($this) => {
  return [
    {
      formType: 'div',
      name: '5.1 一般体征',
      className: 'sec-title',
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title',
      prop: 'd1',
      model: 'd1',
      placeholder: '请选择',
      label: '检查时间',
      format: 'yyyy-MM-dd',
      type: 'date',
      rules: [{required: true, message: '手术时间', trigger: 'blur'}],
      spanNum: 24,
    },
    {
      formType: 'input',
      className: 'obj-form-title',
      prop: 'd2',
      model: 'd2',
      label: '身高',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'cm', type: 'append'}],
      rules: [{required: true, message: '请输入身高', trigger: 'blur'}],
    },
    {
      formType: 'input',
      className: 'obj-form-title',
      prop: 'd3',
      model: 'd3',
      label: '体重',
      disabled: false,
      placeholder: '请输入（体重可以带1位小数点）',
      spanNum: 8,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'kg', type: 'append'}],
      rules: [{required: true, message: '请输入体重', trigger: 'blur'}],
    },
    {
      formType: 'input',
      className: 'obj-form-title',
      prop: 'd4',
      model: 'd4',
      label: 'BMI（系统自动生成）',
      disabled: false,
      placeholder: '22.5（这里是自动计算所得）',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'kg/m^2', type: 'append'}],
    },

    {
      formType: 'input',
      className: 'obj-form-title',
      prop: 'd3',
      model: 'd3',
      label: '腰围',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'cm', type: 'append'}],
      rules: [{required: true, message: '请输入腰围', trigger: 'blur'}],
    },


    {
      formType: 'div',
      name: '5.2 血压（同侧，测量2次）',
      className: 'sec-title',
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title',
      prop: 'd5',
      model: 'd5',
      placeholder: '请选择',
      label: '测量时间',
      format: 'yyyy-MM-dd',
      type: 'date',
      rules: [{required: true, message: '请选择测量时间', trigger: 'blur'}],
      spanNum: 24,
    },
    {
      formType: 'div',
      name: '第一次',
      className: 'third-title',
    },
    {
      formType: 'input',
      className: 'obj-form-title',
      prop: 'd6',
      model: 'd6',
      label: '收缩压SBP',
      disabled: false,
      placeholder: '请输入',
      spanNum: 24,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmHg', type: 'append'}]
    },
    {
      formType: 'input',
      className: 'obj-form-title',
      prop: 'd7',
      model: 'd7',
      label: '舒张压DBP',
      disabled: false,
      placeholder: '请输入',
      spanNum: 24,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmHg', type: 'append'}]
    },
    {
      formType: 'input',
      className: 'obj-form-title',
      prop: 'd8',
      model: 'd8',
      label: '脉搏',
      disabled: false,
      placeholder: '请输入',
      spanNum: 24,
      type: 'number',
      labmsg: '次',
      slots: [{name: '次/分', type: 'append'}]
    },

    {
      formType: 'div',
      name: '第二次',
      className: 'third-title',
    },
    {
      formType: 'input',
      className: 'obj-form-title',
      prop: 'd9',
      model: 'd9',
      label: '收缩压SBP',
      disabled: false,
      placeholder: '请输入',
      spanNum: 24,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmHg', type: 'append'}]
    },
    {
      formType: 'input',
      className: 'obj-form-title',
      prop: 'd10',
      model: 'd10',
      label: '舒张压DBP',
      disabled: false,
      placeholder: '请输入',
      spanNum: 24,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmHg', type: 'append'}]
    },
    {
      formType: 'input',
      className: 'obj-form-title',
      prop: 'd11',
      model: 'd11',
      label: '脉搏',
      disabled: false,
      placeholder: '请输入',
      spanNum: 24,
      type: 'number',
      labmsg: '次',
      slots: [{name: '次/分', type: 'append'}]
    },


    {
      formType: 'div',
      name: '5.3 心脏听诊',
      className: 'sec-title',
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title',
      prop: 'd12',
      model: 'd12',
      placeholder: '请选择',
      label: '测量时间',
      format: 'yyyy-MM-dd',
      type: 'date',
      rules: [{required: true, message: '测量时间', trigger: 'blur'}],
      spanNum: 24,
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'd13',
      model: 'd13',
      label: '心脏杂音',
      disabled: false,
      spanNum: 24,
      options: [
        {label: '无', value: '1', disabled: false},
        {label: '有', value: '2', disabled: false},
      ],
      rules: [{required: true, message: '请选择心脏杂音', trigger: 'blur'}]
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'd14',
      model: 'd14',
      label: '心律',
      disabled: false,
      spanNum: 24,
      options: [
        {label: '整齐', value: '1', disabled: false},
        {label: '不齐', value: '2', disabled: false},
      ],
      rules: [{required: true, message: '请选择心律', trigger: 'blur'}]
    },
  ]
}
