import followApi from '../../../utils/followup/followapis'

export default {
  namespaced: true,
  state: {
    residentList: { //居民列表
      pageNum: 1, //当前页码
      pageSize: 10, //每页数据大小
      total: null,  //总数
    },
    groupList: [],  //分组列表
    residentDetail: {}, //居民详情,
    planDetail: {}, // 计划详情页

  },
  mutations: {
    GET_RESIDENT_LIST(state, payload) {
      state.residentList = payload
    },
    GET_GROUP_LIST(state, payload) {
      state.groupList = payload.labelDtoList
    },
    GET_RESIDENT_DETAIL(state, payload) {
      state.residentDetail = payload
    },
    GET_RESIDENT_DETAIL(state, payload) {
      state.residentDetail = payload
    }
  },
  actions: {
    getResidentList(context, payload) {
      const { pageSize, pageNum } = context.state.residentList;
      followApi.getResidentList({
        pageSize,
        pageNum,
        ...payload
      }).then(({data}) => {
        context.commit('GET_RESIDENT_LIST', data);
      });
    },
    getGroupList(context, payload) {
      followApi.getGroupList({}).then(({data}) => {
        context.commit('GET_GROUP_LIST', data);
      });
    },
    getResidentDetail(context, payload) {
      followApi.getResidentDetail({
        ...payload
      }).then(({data}) => {
        context.commit('GET_RESIDENT_DETAIL', data);
      });
    }
  },
}
