import fetch from '../fetch';
import { getBaseUrl } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token: localStorage.getItem('storageToken'),
};

export const saveStore = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/upsert`),
    method: 'post',
    data: params,
    description: '新建编辑店铺',
  })
};

export const queryStoreInfo = (storeId) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/query?storeId=${storeId}`),
    method: 'get',
    // params: params,
    description: '查询单个店铺信息',
  })
};