import fetch from '../fetch';
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'
import utils from '@/utils/followup/followupUtils';

const headers = {
  // sysCode: 9,
  productType: 1,  // productType 产品线类型，1 表示云鹊医产品系，2 表示云鹊健康产品系
  sourceType:  3,  // sourceType 终端来源，1 表示安卓，2 表示 ios，3 表示 web，4 表示 H5 登录，5 表示 admin 后台
}

// 获取 RSA public key
export const getPubKey = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`account/cipher/key`),
    method: 'get',
    params: params,
    description: 'get public key',
  })
};

// 密码登录
export const handleLogin = data => {
  return fetch({
    headers,
    url: getBaseUrl(`account/login`),
    method: 'post',
    data: data,
    description: '密码登录',
  })
}




