export function dustributeOption(legendData, seriesData) {
  let option = {
    title: {
      text: "",
      x: "left"
    },
    tooltip: {
      trigger: "item",
      formatter: "{b} : {d}%"
    },
    label: {
      formatter: "{d}%"
    },
    color: ['#FF9A4B', '#39AF9A', '#FFB01B'],
    legend: {
      orient: "horizontal",
      top: "",
      // left: "10%",
      data: legendData
    },
    series: [
      {
        name: "",
        type: "pie",
        radius: "60%",
        center: ["55%", "50%"],
        data: seriesData,
        itemStyle: {
          emphasis: {
            shadowBlur: 10,
            shadowOffsetX: 0,
            shadowColor: "rgba(0, 0, 0, 0.5)"
          }
        }
      }
    ]
  };
  return option;
}
export function recordOption() {
  let option = {
    title: {
      text: "",
      x: "left"
    },
    tooltip: {
      trigger: "axis",
      axisPointer: {
        // 坐标轴指示器，坐标轴触发有效
        type: "shadow", // 默认为直线，可选为：'line' | 'shadow'
        shadowStyle: {
          shadowColor: '#E3EFED',
          width: 36,
        },
      },
      backgroundColor: 'rgba(0,0,0,0.7)',
      formatter: function (params) {
        let relVal = params[0].name + "人数：";
        let value = 0;
        for (let i = 0, l = params.length; i < l; i++) {
          value += params[i].value;
        }
        relVal += value + "人";
        let divList = [];
        divList[0] = "<div style='background: #FFB01B;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        divList[1] = "<div style='background: #39AF9A;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        divList[2] = "<div style='background: #5D7092;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        for (let j = params.length - 1; j >= 0; j--) {
          relVal +=
            "<br/>" + divList[j % 3] +
            params[j].seriesName +
            "占比： " +
            (
              (100 * parseFloat(params[j].value)) /
              parseFloat(value)
            ).toFixed(2) +
            "%";
        }
        return relVal;
      }
    },
    color: ['#FFB01B', '#39AF9A', '#5D7092'],
    legend: {
      data: ["未获证人数", "获优秀人数", "获及格人数"]
    },
    grid: {
      left: "3%",
      right: "4%",
      bottom: "3%",
      containLabel: true
    },
    xAxis: {
      type: "category",
      data: ["博士", "硕士", "本科", "大专", "中专及以下", "其他"]
    },
    yAxis: {
      type: "value",
      name: "人数 (个)"
    },
    series: [
      {
        name: "获及格人数",
        type: "bar",
        stack: "总量",
        barWidth: 18,
        label: {
          normal: {
            show: true,
            rotate: -90,
          }
        },
        data: [220, 182, 191, 234, 290, 330]
      },
      {
        name: "获优秀人数",
        type: "bar",
        stack: "总量",
        barWidth: 18,
        label: {
          normal: {
            show: true,
            rotate: -90,
          }
        },
        data: [120, 132, 101, 134, 90, 230]
      },
      {
        name: "未获证人数",
        type: "bar",
        stack: "总量",
        barWidth: 18,
        label: {
          normal: {
            show: true,
            rotate: -90,
          }
        },
        data: [1, 302, 301, 334, 390, 330]
      },
    ]
  };
  return option;
}
export function certificateOption() {
  let option = {
    title: {
      text: "",
      x: "left"
    },
    tooltip: {
      trigger: "axis",
      axisPointer: {
        type: "cross",
        crossStyle: {
          color: "#999"
        }
      },
      backgroundColor: 'rgba(0,0,0,0.7)',
      formatter: function (params) {
        let relVal = "";
        let divList = [];
        divList[0] = "<div style='background: #5D7092;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        divList[1] = "<div style='background: #FFB01B;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        divList[2] = "<div style='background: #559A99;height: 12px;width: 12px;margin: 5px 5px 0 5px;float: left;border-radius:50%;'></div>";
        for (let j = 0, l = params.length; j < l; j++) {
          relVal += divList[j] + params[j].seriesName + "： " + params[j].value;
          if (j === 2) {
            relVal += "%";
          } else {
            relVal += "<br/>";
          }
        }
        return relVal;
      }
    },
    color: ['#5D7092', '#FFB01B', '#559A99'],
    dataZoom: {
      show: true,
      start: 0,
      end: 60
    },
    legend: {
      data: ["参与人数", "获证人数", "获证比例"]
    },
    xAxis: [
      {
        axisLabel: {
          interval: 0,
          rotate: 45
        },
        type: "category",
        data: [
          "北京市",
          "天津市",
          "河北省",
          "山西省",
          "内蒙古自治区",
          "辽宁省",
          "吉林省",
          "黑龙江省",
          "上海市",
          "江苏省",
          "浙江省",
          "安徽省",
          "福建省",
          "江西省",
          "山东省",
          "河南省",
          "湖北省",
          "湖南省",
          "广东省",
          "广西壮族自治区",
          "海南省",
          "重庆市",
          "四川省",
          "贵州省",
          "云南省",
          "西藏自治区",
          "陕西省",
          "甘肃省",
          "青海省",
          "宁夏回族自治区",
          "新疆维吾尔自治区"
        ],
        axisPointer: {
          type: "shadow"
        }
      }
    ],
    yAxis: [
      {
        type: "value",
        name: "人数（个）",
        axisLabel: {
          formatter: "{value} "
        }
      },
      {
        type: "value",
        name: "比例",
        min: 0,
        max: 100,
        axisLabel: {
          formatter: "{value} %"
        }
      }
    ],
    series: [
      {
        name: "参与人数",
        barWidth: 10,
        type: "bar",
        data: [
          10,
          52,
          200,
          334,
          390,
          330,
          220,
          10,
          52,
          200,
          334,
          390,
          330,
          220,
          10,
          52,
          200,
          334,
          390,
          330,
          220,
          10,
          52,
          200,
          334,
          390,
          330,
          220,
          10,
          52,
          200,
          334,
          390
        ],
        label: {
          show: true,
          position: "top",
          formatter: "{c}", //这是关键，在需要的地方加上就行了
          rotate: -90,
          offset: [-5, -15]
        }
      },
      {
        name: "获证人数",
        barWidth: 10,
        type: "bar",
        data: [9, 8, 100, 200, 200, 55, 10, 9, 8, 100, 200, 200, 55, 10, 9, 8, 100, 200, 200, 55, 10],
        label: {
          show: true,
          position: "top",
          formatter: "{c}", //这是关键，在需要的地方加上就行了
          rotate: -90,
          offset: [-5, -15]
        }
      },
      {
        name: "获证比例",
        type: "line",
        yAxisIndex: 1,
        data: [
          2,
          22,
          32,
          41,
          61,
          10,
          20,
          23,
          55,
          67,
          91,
          6,
          2,
          22,
          32,
          41,
          61,
          10,
          20,
          23,
          55,
          67,
          91,
          6
        ],
        label: {
          show: true,
          position: "top",
          formatter: "{c}%" //这是关键，在需要的地方加上就行了
        }
      }
    ]
  };
  return option;
}
export function durationOption() {
  let option = {
    title: {
      text: "",
      x: "left"
    },
    tooltip: {
      trigger: "axis",
      axisPointer: {
        type: "shadow" // 默认为直线，可选为：'line' | 'shadow'
      }
    },
    color: ['#449284'],
    grid: {
      left: "3%",
      right: "4%",
      bottom: "3%",
      containLabel: true
    },
    dataZoom: {
      show: true,
      start: 0,
      end: 66
    },
    xAxis: [
      {
        axisLabel: {
          interval: 0,
          rotate: 35
        },
        type: "category",
        data: [
          "北京市",
          "天津市",
          "河北省",
          "山西省",
          "内蒙古自治区",
          "辽宁省",
          "吉林省",
          "黑龙江省",
          "上海市",
          "江苏省",
          "浙江省",
          "安徽省",
          "福建省",
          "江西省",
          "山东省",
          "河南省",
          "湖北省",
          "湖南省",
          "广东省",
          "广西壮族自治区",
          "海南省",
          "重庆市",
          "四川省",
          "贵州省",
          "云南省",
          "西藏自治区",
          "陕西省",
          "甘肃省",
          "青海省",
          "宁夏回族自治区",
          "新疆维吾尔自治区"
        ],
        axisTick: {
          alignWithLabel: true
        }
      }
    ],
    yAxis: [
      {
        type: "value",
        name: "完成时长 (天)"
      }
    ],
    series: [
      {
        name: "时长",
        type: "bar",
        barWidth: 17,
        data: [
          10,
          52,
          200,
          334,
          390,
          330,
          220,
          10,
          52,
          200,
          334,
          390,
          330,
          220,
          10,
          52,
          200,
          334,
          390,
          330,
          220,
          10,
          52,
          200,
          334,
          390,
          330,
          220,
          10,
          52,
          200,
          334,
          390
        ],
        label: {
          show: true,
          position: "top",
          formatter: "{c}", //这是关键，在需要的地方加上就行了
          rotate: -90,
          offset: [-5, -15]
        }
      }
    ]
  };
  return option;
}

export function educationEffect(xAxisData, seriesBefore ,seriesAfter) {
  let option = {
    title: {
      text: ""
    },
    tooltip: {
      trigger: "axis",
      axisPointer: {
        type: "shadow"
      }
    },
    color: ["#5D7092", "#FFB01B"],
    legend: {
      data: ["项目前总正确率", "项目后总正确率"]
    },
    grid: {
      left: "3%",
      right: "4%",
      bottom: "3%",
      containLabel: true
    },
    xAxis: {
      type: "category",
      data: xAxisData
    },
    yAxis: {
      min: 0,
      max: 100,
      type: "value",
      axisLabel: {
        formatter: "{value} %"
      }
    },
    series: [
      {
        name: "项目前总正确率",
        type: "bar",
        barWidth: 10,
        data: seriesBefore,
      },
      {
        name: "项目后总正确率",
        type: "bar",
        barWidth: 10,
        data: seriesAfter,
      }
    ]
  };
  return option;
}

export function knowledgeEffect(xAxisData, seriesBefore ,seriesAfter) {
  let option = {
    title: {
      text: ""
    },
    tooltip: {
      trigger: "axis",
      axisPointer: {
        type: "shadow"
      }
    },
    color: ["#5D7092", "#FFB01B"],
    legend: {
      data: ["培训前正确率", "培训后正确率"]
    },
    grid: {
      left: "3%",
      right: "4%",
      bottom: "3%",
      containLabel: true
    },
    xAxis: {
      axisLabel: {
        interval: 0,
        rotate: 45
      },
      type: "category",
      data: xAxisData,
    },
    yAxis: {
      min: 0,
      max: 100,
      type: "value",
      axisLabel: {
        formatter: "{value} %"
      }
    },
    series: [
      {
        name: "培训前正确率",
        type: "bar",
        barWidth: 10,
        data: seriesBefore,
      },
      {
        name: "培训后正确率",
        type: "bar",
        barWidth: 10,
        data: seriesAfter
      }
    ]
  };
  return option;
}

export function examTimes() {
  let option = {
    title: {
      text: "",
      x: "left"
    },
    tooltip: {
      trigger: "axis",
      axisPointer: {
        type: "shadow" // 默认为直线，可选为：'line' | 'shadow'
      }
    },
    color: ['#449284'],
    grid: {
      left: "3%",
      right: "4%",
      bottom: "3%",
      containLabel: true
    },
    dataZoom: {
      show: true,
      start: 0,
      end: 66
    },
    xAxis: [
      {
        axisLabel: {
          interval: 0,
          rotate: 35
        },
        type: "category",
        data: [
          "1次",
          "2次"
        ],
        axisTick: {
          alignWithLabel: true
        }
      }
    ],
    yAxis: [
      {
        type: "value",
        name: "完成时长 (天)"
      }
    ],
    series: [
      {
        name: "时长",
        type: "bar",
        barWidth: 17,
        data: [
        ],
        label: {
          show: true,
          position: "top",
          formatter: "{c}", //这是关键，在需要的地方加上就行了
          rotate: -90,
          offset: [-5, -15]
        }
      }
    ]
  };
  return option;
}