import { checkCardNum } from '@/utils/followup/followupUtils/checkCardNum';

export default ($this) => {

  return [
    {
      formType: 'div',
      name: '1.1 人口学信息',
      className: 'sec-title',
    },
    {
      formType: 'input',
      className: 'float-none margin-left-20',
      prop: 'name',
      model: 'name',
      label: '姓名：',
      disabled: false,
      placeholder: '请输入姓名',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '次',
      rules: [{required: true, message: '请输入姓名', trigger: ['submit','change']}],
    },
    {
      formType: 'input',
      className: 'float-none margin-left-20',
      prop: 'idNo',
      model: 'idNo',
      label: '身份证：',
      disabled: false,
      placeholder: '请输入身份证',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '次',
      rules: [{required: true, message: '请输入身份证', trigger: ['submit','change']},{ validator: checkCardNum , trigger: ['submit','change'] }],
    },
    {
      formType: 'radio',
      className: 'obj-form-title margin-left-20',
      prop: 'inTurn',
      model: 'inTurn',
      spanNum: 24,
      label: '随访轮次（距离建档时间）：',
      options: [
        { label: '6个月', value: '6个月' },
        { label: '12个月', value: '12个月' },
      ],
      rules: [{ required: true, message: '请选择随访轮次', trigger: ['submit','change'] }],
      changeFun: (e)=>{
        // console.log(e)
        // if(e == '12个月'){
        //   $this.needRule = false;
        //   sessionStorage.setItem('needRule',false);
        // }else{
        //   $this.needRule = true;
        //   sessionStorage.setItem('needRule',true);
        // }


        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'CheckBody'){
            item.dataSource.forEach((item2,index2)=>{
              if(e == '12个月'){
                $this.needRule = false;
                sessionStorage.setItem('needRule',false);
                if(item2.rules){
                  $this.addComponents[index].dataSource[index2].rules[0].required = true
                }
              }else{
                $this.needRule = true;
                sessionStorage.setItem('needRule',true);
                if(item2.rules){
                  $this.addComponents[index].dataSource[index2].rules[0].required = false
                }
              }
            })
          }

        })


      }
    },
  ]
}

