import fetch from '../fetch';
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token: localStorage.getItem('storageToken'),
};


export const getAuth = () => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/user/auth`),
    method: 'get',
    description: '查看外部用户权限接口',
  })
};

export const getRangeList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/list`),
    method: 'post',
    data: params,
    description: '查看圈子列表',
  })
};

export const updateRangeStatus = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/change/${params.id}/status/to/${params.status}`),
    method: 'get',
    // params: params,
    description: '查询单个直播',
  })
};

export const getRtcInfo = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`rtc/liveAdmin/${params.rtcId}`),
    method: 'get',
    // params: params,
    description: '查询单个直播',
  })
};

// 查询回放信息
export const getPlayback = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`rtc/liveAdmin/playback/${params.rtcId}`),
    method: 'get',
    // params: params,
    description: '查询回放信息',
  })
};

export const postPlayback = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`rtc/liveAdmin/playback`),
    method: 'post',
    data: params,
    description: '设置/关闭回放',
  })
};

export const updateLiveStatus = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`rtc/liveAdmin/switchLiveStatus`),
    method: 'put',
    data: params,
    description: '更新直播状态',
  })
};


export const getImages = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`rtc/liveAdmin/backgroundImage`),
    method: 'get',
    description: '查询可用背景图',
  })
};

