import { checkRange, checkIsInteger, checkNumberIsToFixed } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  return [
    {
      formType: 'input',
      className: 'float-none',
      prop: 'fastingBloodSugar',
      model: 'fastingBloodSugar',
      disabled: false,
      label: '空腹血糖值：',
      placeholder: '请输入空腹血糖值',
      spanNum: 6,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      slots: [{name: 'mmol/L', type: 'append'}],
      rules: [{ required: true, message: '请输入空腹血糖值', trigger: ['submit','change'] }]
    },
    {
      formType: 'div',
      name: '其他检查',
      className: 'sec-title',
    },
    {
      formType: 'input',
      // className: 'float-none  margin-left-20',
      className: 'float-none',
      prop: 'fastingBloodSugar',
      model: 'fastingBloodSugar',
      disabled: false,
      label: '糖化血红蛋白值：',
      placeholder: '请输入糖化血红蛋白值',
      spanNum: 6,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      slots: [{name: '%', type: 'append'}],
      rules: [{ required: true, message: '请输入糖化血红蛋白值', trigger: ['submit','change'] }]
    },
    {
      formType: 'date-picker',
      className: 'float-none',
      prop: 'glycosylatedHemoglobinDate',
      model: 'glycosylatedHemoglobinDate',
      placeholder: '请选择',
      label: '检查日期：',
      format: 'MM 月 dd 日',
      valueFormat: 'MM-dd',
      dateType: 'date',
      type: 'date',
      rules: [{required: true, message: '请选择检查日期', trigger: ['submit','change']}],
      spanNum: 12,
    },
  ]
}

