import { checkRange, checkIsInteger, checkNumberIsToFixed } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  return [
    {
      formType: 'input',
      className: 'float-none',
      prop: 'systolicBloodPressure',
      model: 'systolicBloodPressure',
      label: '收缩压SBP：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmHg', type: 'append'}],
      rules: [{required: true, message: '请输入收缩压SBP', trigger: ['submit','change']},{ validator: checkRange , trigger: ['submit','change'] },{ validator: checkIsInteger , trigger: ['submit','change'] }],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'diastolicBloodPressure',
      model: 'diastolicBloodPressure',
      label: '舒张压DBP：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmHg', type: 'append'}],
      rules: [{required: true, message: '请输入舒张压DBP', trigger: ['submit','change']},{ validator: checkRange , trigger: ['submit','change'] },{ validator: checkIsInteger , trigger: ['submit','change'] }],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'bodyHeight',
      model: 'bodyHeight',
      label: '身高：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'cm', type: 'append'}],
      rules: [{required: true, message: '请输入身高', trigger: ['submit','change']},{ validator: checkRange , trigger: ['submit','change'] }, {validator: checkNumberIsToFixed , trigger: ['submit','change']}],
      changeFun: (val)=>{
        $this.addComponents.forEach((item,index)=>{
          if(item.formName == 'diabetes_002'){
            $this.addComponents[index].formObject.bodyHeight = val;
          }
        })

      },
      blurFunc: (val)=>{
        $this.addComponents.forEach((item,index)=>{
          if(item.formName == 'diabetes_002'){
            let bodyWeight = $this.addComponents[index].formObject.bodyWeight
            let bodyHeight = $this.addComponents[index].formObject.bodyHeight
            if(bodyWeight && bodyHeight){
              bodyWeight = parseFloat(bodyWeight);
              bodyHeight = parseFloat(bodyHeight);
              let bmi = (bodyWeight / Math.pow((bodyHeight/100),2)).toFixed(1);
              $this.addComponents[index].formObject.bmi = bmi;
            }
          }
        })
      }
    },
    // 体质指数（BMI）=体重（kg）÷ 身高²（m）
    {
      formType: 'input',
      className: 'float-none',
      prop: 'bodyWeight',
      model: 'bodyWeight',
      label: '体重：',
      disabled: false,
      placeholder: '请输入（体重可以带1位小数点）',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'kg', type: 'append'}],
      rules: [{required: true, message: '请输入体重', trigger: ['submit','change']},{ validator: checkRange , trigger: ['submit','change'] }, {validator: checkNumberIsToFixed , trigger: ['submit','change']}],
      changeFun: (val)=>{
        $this.addComponents.forEach((item,index)=>{
          if(item.formName == 'diabetes_002'){
            $this.addComponents[index].formObject.bodyWeight = val;
          }
        })
      },
      blurFunc: (val)=>{
        $this.addComponents.forEach((item,index)=>{
          if(item.formName == 'diabetes_002'){
            let bodyWeight = $this.addComponents[index].formObject.bodyWeight
            let bodyHeight = $this.addComponents[index].formObject.bodyHeight
            if(bodyWeight && bodyHeight){
              bodyWeight = parseFloat(bodyWeight);
              bodyHeight = parseFloat(bodyHeight);
              let bmi = (bodyWeight / Math.pow((bodyHeight/100),2)).toFixed(1);
              $this.addComponents[index].formObject.bmi = bmi;
            }
          }
        })
      }
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'bmi',
      model: 'bmi',
      label: 'BMI（系统自动生成）：',
      disabled: true,
      placeholder: '（这里是自动计算所得）',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'kg/m^2', type: 'append'}],
    },
    {
      formType: 'input',
      className: 'obj-form-title',
      linkageRule: [{name: 'symptom',value: ['其他']}],
      prop: 'remark',
      model: 'remark',
      disabled: false,
      placeholder: '请输入其他体征',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入其他体征', trigger: ['submit','change'] }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'dorsalisPedisArteryPulsation',
      model: 'dorsalisPedisArteryPulsation',
      label: '足背动脉搏动：',
      // linkageRule: [{ name: 'takeAntithrombotics', value: ['是'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '触及正常', value: '触及正常', disabled: false },
        { label: '双侧减弱', value: '双侧减弱', disabled: false },
        { label: '左侧减弱', value: '左侧减弱', disabled: false },
        { label: '右侧减弱', value: '右侧减弱', disabled: false },
        { label: '双侧消失', value: '双侧消失', disabled: false },
        { label: '左侧消失', value: '左侧消失', disabled: false },
        { label: '右侧消失', value: '右侧消失', disabled: false },
      ],
      rules: [{ required: true, message: '请选择足背动脉搏动情况', trigger: ['submit','change'] }]
    },
  ]
}

