import fetch from '../fetch';
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'


const headers = {
  sysCode: 9
}
/*居民管理*/
export const getDiseasesList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/diseases/-1`),
    method: 'get',
    params: params,
    description: '获取所有疾病',
  })
};

export const getLabelList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/labels/`),
    method: 'get',
    params: params,
    description: '获取分组列表',
  })
}

export const createNewLabel = (data) => {
  return fetch({
    url: getBaseUrl(`healths/labels/`),
    headers: {
      "Content-Type": 'application/json'
    },
    method: 'post',
    data: data,
    description: '新增分组',
  })
}

export const changeLabelName = (data) => {
  return fetch({
    url: getBaseUrl(`healths/labels/`),
    // headers: {
    //   "Content-Type": 'application/json'
    // },
    method: 'put',
    data: data,
    description: '修改分组名',
  })
}

export const getLabelDetail = (labelId, params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/labels/${labelId}/patients`),
    method: 'get',
    params: params,
    description: '获取分组详情',
  })
}

export const deleteCurrentLabel = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/labels/`),
    method: 'delete',
    data: data,
    description: '删除分组',
  })
}

export const deleteCurrentPatients = data => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/labels/patients`),
    method: 'delete',
    data: data,
    description: '删除分组下的居民',
  })
}

// 获取七牛上传token
export const getQiniuToken = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`file/image/token`),
    method: 'get',
    params: params,
  })
};

// 意见反馈 getSaasApiDomain
export const submitFeedback = (data) => {
  return fetch({
    headers: {
      noSysCode: true,
      "Content-Type": 'application/json'
    },
    url: getSaasApiDomain(`web/companys/feedback`),
    method: 'post',
    data: data,
  })
};

/*资料不全居民*/
export const getNotCompleteList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/uncomplate/${params.pageNo}/${params.pageSize}`),
    method: 'get',
    description: '获取资料不全居民列表',
  })
};
export const sendCompleteMessage = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/remind`),
    method: 'post',
    data: params,
    description: '提醒居民完善信息',
  })
};
export const getNotCompleteCount = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/uncomplate/counts`),
    method: 'get',
    data: params,
    description: '获取未完善居民人数',
  })
};

export const getPatientDetail = (patientId) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/${patientId}`),
    method: 'get',
    // params: params,
    description: '获取居民详情',
  })
};
