import fetch from '../fetch';
import { getFollowUpApi, getBasicDataApi, getFollowUpSC } from '@/utils/index'

import utils from './followupUtils';





const headers = {
  sysCode: 45,
  hospitalAuth:true
} /**/
/*工作台*/
export const getTodayAppointsList = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/overView/todayAppoints`),
    method: 'get',
    params: params,
    description: '获取今日预约列表',
  })
};
export const getTodayOverview = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/overView/todayOverview`),
    method: 'get',
    params: params,
    description: '获取今日履约、预约、履约人数',
  })
};
export const getTodayPlans = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/overView/todayPlans`),
    method: 'get',
    params: params,
    description: '查询今日履约计划',
  })
};

/*计划管理*/
export const createFollowPlan = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/plans`),
      method: 'post',
      data: data,
      description: '新增、修改履约计划',
    })
  })

}
export const getPlanList = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/plans`),
      method: 'get',
      params: params,
      description: '获取计划列表',
    })
  // })

};
export const getPlanDetail = (planId) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/plans/${planId}`),
      method: 'get',
      description: '获取计划详情',
    })
  // })

};
export const getNodeTimeList = (planId) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/plans/${planId}/time`),
      method: 'get',
      description: '获取履约时间节点列表',
    })
  // })

};
export const getNodeTimeContent = (planTimeId) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/plans/time/${planTimeId}`),
      method: 'get',
      description: '获取节点详情',
    })
  // })

};
export const getResidentList = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/planPatient/`),
      method: 'get',
      params: params,
      description: '获取居民列表',
    })
  // })

};
export const getGroupList = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/planPatient/group`),
      method: 'get',
      params: params,
      description: '获取分组列表',
    })
  // })

};
export const getFollowStartTimeList = (planId) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/planPatient/${planId}/times`),
      method: 'get',
      description: '获取履约开始时间列表（居民相关）',
    })
  // })

};
export const getResidentDetail = (planId,patientId,fuPlanPatientId ) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/planPatient/${planId}/detail/${patientId}?planPatientsId=${fuPlanPatientId}`),
      method: 'get',
      description: '获取居民详情',
    })
  // })

};
export const changePlan = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/planPatient/change`),
      method: 'put',
      data: data,
      description: '变更计划',
    })
  })

};
export const finishPlan = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/planPatient/status`),
      method: 'put',
      data: data,
      description: '变更计划',
    })
  })

};
export const deletePlan = (planId) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/plans/${planId}`),
      method: 'delete',
      description: '删除计划',
    })
  })

};
export const getVerifyStatus = (params) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/plans/validate/status`),
      method: 'get',
      params: params,
      description: '认证校验',
    })
  })

};
/*预约管理*/
export const getReservationList = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/appoint/appointed/list`),
      method: 'post',
      data: data,
      description: '获取预约列表',
    })
  })

};
export const getCheckReservation = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/healths/notice/fu/doctor/appoint/pushValid`),
      method: 'post',
      data: data,
      description: '发送预约校验',
    })
  })

};
export const getReservationPatients = (data) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/appoint/appointed/count`),
      method: 'post',
      data: data,
      description: '查看预约人数',
    })
  // })

};
export const changeReservationStatus = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/appoint/status/`),
      method: 'post',
      data: data,
      description: '手动变更预约状态',
    })
  })

};
export const sendReservation = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/appoint/`),
      method: 'post',
      data: data,
      description: '发送预约',
    })
  })

};
/*录入管理*/
export const getEnteringList = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/entering/list`),
      method: 'post',
      data: data,
      description: '录入列表查看',
    })
  })

}
export const changeEnteringStatus = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/entering/status/change`),
      method: 'post',
      data: data,
      description: '变更履约状态',
    })
  })

}
export const getEnteringInfo = (patientId, fuPlanPatientTimesId) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/entering/${patientId}/fuInfo/${fuPlanPatientTimesId}`),
      method: 'get',
      // params: params,
      description: '履约单条信息查看',
    },)
  // })

}
export const getFormList = (planTimesId) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/entering/scale/${planTimesId}/list`),
      method: 'get',
      // params: params,
      description: '获取量表列表',
    },)
  // })

}

//获取新建计划居民列表
export const getPlanPatientsList = (data) =>{
  // return utils.checkAuth(()=>{
    return fetch({
      headers:{
        sysCode: 9,
        hospitalAuth:true
      },
      url: getFollowUpSC(`/healths/patients/infolist`),
      method: 'post',
      data: data,
      description: '获取新建计划居民列表',
    },)
  // })

}

// 获取履约计划模板列表
export const getFollowupTemplate = (data) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/plans/templets`),
      method: 'get',
      data: data,
      description: '获取履约计划模板列表',
    })
  // })

}

// 获取履约量表固定模板
export const getFollowupTableTemplate = (id) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/plans/templets/${id}`),
      method: 'get',
      data: {},
      description: '获取履约量表固定模板',
    })
  // })

}

// 获取量表列表
export const getFormOptions = (data)=>{
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/followup/entering/scale/list`),
      method: 'get',
      data: data,
      description: '获取量表列表',
    })
  // })

}

/*常量*/
export const getBasicData = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/basic-data/constants/`),
      method: 'get',
      params: params,
      description: '获取常量',
    })
  // })

};

// 获取所有漫画列表
export const getAllEducationComtent = (data) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/healths/comtent/workstation/list`),
      method: 'post',
      data: data,
      description: '获取所有漫画列表'
    })
  // })

}

// 获取所有疾病
export const getAllDiseases = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/healths/patients/diseases/-1`),
      method: 'get',
      params: params,
      description: '获取所有疾病',
    })
  // })

}

// 获取所有分组
export const getAllLabels = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getFollowUpSC(`/healths/labels/`),
      method: 'get',
      params: params,
      description: '获取所有分组',
    })
  // })

}

// 获取微信和短信病人数接口
export const getPatientNumber = (data) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers: {
        sysCode: 9,
        hospitalAuth:true
      },
      url: getFollowUpSC(`/healths/patientEducation/getSendPatientTypeNum`),
      method: 'post',
      data: data,
      description: '获取微信和短信病人数接口',
    })
  // })

}


/*
 * 量表相关
 */

// 获取域名白名单
export const getDomain = (data) => {
  return fetch({
    url: getFollowUpSC(`/followup/route/domain?type=1`),
    method: 'get',
    data: {},
  })
}

// 获取展示的模块
export const getScaleModels = (domain,scaleNo) => {
  return fetch({
    url: `${domain}/scale/${scaleNo}/models`,
    method: 'get',
    data: {},
  })
}

// 获取量表详情
export const getScaleDetail = (domain,planPatientsTimesId,scaleNo) => {
  return fetch({
    url: `${domain}/scale/${planPatientsTimesId}/${scaleNo}/info?type=2&isLine=2`,
    method: 'get',
    data: {},
  })
}

// 提交量表
export const postScale = ( domain,data ) => {
  return fetch({
    url: `${domain}/scale/save`,
    method: 'post',
    data: JSON.stringify(data),
  })
}

// 更新量表状态
export const updateScalesStatus = ( data ) => {
  return fetch({
    url: getFollowUpSC(`/followup/entering/scale/updateScalesStatus`),
    method: 'post',
    data: data,
  })
}

// 获取量表详情
export const getFirstAccess = () => {
  return fetch({
    url: getFollowUpSC(`/followup/overView/firstAccess`),
    method: 'get',
    data: {},
  })
}

  /**
   * Add by Anndy Yang
   * 统一验证：量表内是否存在敏感字段、居民是否签署隐私协议、7天内是否发送过授权短信
   * @param  {[type]} data
    {
      "scaleNo":"String,量表编号",
      // "patientIds":"List<Integer>,医生/居民id集合",        // pc端只传这个字段
      "planPatientsTimesId": "planPatientsTimesId",         // app端只传这个字段
      "protocolType":"Integer,协议类型（1：平台用户协议，5：隐私协议）",
      "userType":"Integer,用户类型（1：居民，2：医生，3：其他）",
      "validateType":"1：3个条件依次校验，2：后面2个条件依次校验"
    }
  * @return {[type]}
    {
      "code": "000000",
      "message": "成功",
      "data": {
        "levelType":"类型 1：量表不存在敏感字段，2：居民都已签署协议，3：7天内发送过授权短信，4：7天内未发送过授权短信"
        "ids":"List<Integer>,未签署协议的id集合（需要发送授权短信的居民id集合）"
      }
    }
  */
  export const uniteValidate = (data) => {
    return fetch({
      url: getFollowUpSC(`/followup/protocol/uniteValidate`),
      method: 'post',
      data: data,
    })
  };

  /**
  * Add by Anndy Yang
  * [批量]医生给居民发送授权短信
  * @param  {[type]} data {"patientIds":"List<Integer>，居民id集合"}
  * @return {[type]}      [description]
  */

 export const authMessage = (data) => {
  return fetch({
    url: getFollowUpSC(`/followup/protocol/authMessage`),
    method: 'post',
    data: data,
  })
};

// 关于权限获取展示的模块信息
export const getScaleModels2 = (domain,scaleNo, params) => {
  return fetch({
    url: `${domain}/followup/protocol/${scaleNo}/models`,
    method: 'get',
    params: params,
  })
}
