const patientsManage = r => require.ensure([], () => r(require('../views/patients/layout.vue')), 'patientsManage');
/*我的居民*/
const myPatientsManage = r => require.ensure([], () => r(require('../views/patients/mypatients-manage/layout.vue')), 'myPatientsManage');
const patientsList = r => require.ensure([], () => r(require('../views/patients/mypatients-manage/patients-list.vue')), 'patientsList');

/*新增居民*/
const newManage = r => require.ensure([], () => r(require('../views/patients/new-manage/layout.vue')), 'newManage');
const newPatient = r => require.ensure([], () => r(require('../views/patients/new-manage/new-patient.vue')), 'newPatient');



const patientsRouters = {
  path: '/patients-manage',
  name: 'patientsManage',
  component: patientsManage,
  redirect: 'patients-manage/mypatients-manage/patients-list',
  children: [
    {
      path: 'mypatients-manage',
      component: myPatientsManage,
      name: 'myPatientsManage',
      redirect: 'mypatients-manage/patients-list',
      children: [
        {
          path: 'patients-list',
          component: patientsList,
          name: 'patientsList',
          meta: {
            title: '我的居民列表',
            keepAlive: false  //页面不需要缓存
          },
        }
      ],
      meta: {
        title: '我的居民',
      },
    },
    {
      path: 'new-manage',
      component: newManage,
      name: 'newManage',
      redirect: 'new-manage/new-patient',
      children: [
        {
          path: 'new-patient',
          component: newPatient,
          name: 'newPatient',
          meta: {
            title: '新增居民',
            keepAlive: false
          },
        },
      ],
      meta: {
        title: '新增居民',
      },
    },

  ],
};

export default patientsRouters
