import { checkRange, checkIsInteger, checkNumberIsToFixed } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  let hanldeValue = () => {
    $this.addComponents.forEach((item,index)=>{
      if(item.name == 'hypeDataSourceReferral'){
        const reason = item.formObject.reason
        const mechanism = item.formObject.mechanism
        const department = item.formObject.department
        item.dataSource.forEach((item2,index2)=>{
          if((reason||mechanism||department) && item2.rules){
            $this.addComponents[index].dataSource[index2].rules[0].required = true;
          }else{
            $this.addComponents[index].dataSource[index2].rules[0].required = false;
          }
        })
        $this.$refs['form'+index][0].validate();
      }
    })
  }
  return [
    {
      formType: 'input',
      className: 'float-none',
      prop: 'reason',
      model: 'reason',
      refs:'reason',
      label: '原因：',
      disabled: false,
      placeholder: '请输入原因',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      rules: [{required: false, message: '请输入原因', trigger: ['change','submit','blur']}],
      changeFun: hanldeValue,
      blurFunc: hanldeValue
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'mechanism',
      model: 'mechanism',
      refs:'mechanism',
      label: '机构：',
      disabled: false,
      placeholder: '请输入机构',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      rules: [{required: false, message: '请输入机构', trigger: ['change','submit','blur']}],
      changeFun: hanldeValue,
      blurFunc: hanldeValue
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'department',
      model: 'department',
      refs:'department',
      label: '科室：',
      disabled: false,
      placeholder: '请输入科室',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      rules: [{required: false, message: '请输入科室', trigger: ['change','submit','blur']}],
      changeFun: hanldeValue,
      blurFunc: hanldeValue
    },
  ]
}
