import { checkMobile } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  return [
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'hasSymptom',
      model: 'hasSymptom',
      label: '是否有症状：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '无', value: '无', disabled: false },
        { label: '有', value: '有', disabled: false},
      ],
      rules: [{ required: true, message: '请选择履约期间有无症状', trigger: ['submit','change'] }],
      changeFun: (e) => {
        if(e == '有') {
          alert('选择症状,进入')
          $this.addComponents.forEach((item,index)=>{
            if(item.name == 'diabetesSourseSymptom'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                symptom: []
              }
            }
          })
        }
      }
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title',
      prop: 'symptom',
      model: 'symptom',
      label: '选择的症状：',
      linkageRule: [{name: 'hasSymptom', value: ['有']}],
      disabled: false,
      changeFun: (val) => {
        // console.log(val)
      },
      spanNum: 24,
      options: [
        {label: '多饮', value: '多饮', disabled: false},
        {label: '多食', value: '多食', disabled: false},
        {label: '多尿', value: '多尿', disabled: false},
        {label: '视力模糊', value: '视力模糊', disabled: false},
        {label: '感染', value: '感染', disabled: false},
        {label: '手脚麻木', value: '手脚麻木', disabled: false},
        {label: '下肢浮肿', value: '下肢浮肿', disabled: false},
        {label: '体重明显下降', value: '体重明显下降', disabled: false},
        {label: '其他', value: '其他', disabled: false},
      ],
      rules: [{required: true, message: '选择的症状', trigger: ['submit']}]
    },
    {
      formType: 'input',
      className: 'obj-form-title2',
      linkageRule: [{name: 'symptom',value: ['其他']}],
      prop: 'remark',
      model: 'remark',
      disabled: false,
      placeholder: '请输入其他症状',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入其他症状', trigger: ['submit','change'] }]
    },
  ]
}

