import fetch from '../fetch';
import { getFollowUpApi } from '@/utils/index'

import utils from './followupUtils';



/*计划管理API*/
const  planManageApi = [
  {
    url: '/followup/planPatient/',
    method: 'get',
    params: 'params',
    name: 'getResidentList',
    description: '获取居民列表',
  },
  {
    url: '/followup/planPatient/group',
    method: 'get',
    params: 'params',
    name: 'getGroupList',
    description: '获取分组列表',
  },
]




const api = {};
const apis = [...planManageApi];

apis.forEach(item => api[item.name] = (params = {}, extraConfig = {}) => {
  const config = {
    url: getFollowUpApi(item.url),
    method: item.method,
  };

  if (extraConfig.urlSuffix) { // 需要做URL拼接的情况(比如*.do/2),,,可以根据自己的实际情况进行扩展
    config.url = `${config.url}${extraConfig.urlSuffix}`;
    //something else
  }
  const filterParams = utils.DC.getParams(params, item.args);
  if (item.params === 'data') {
    config.data = filterParams;
  } else {
    config.params = filterParams;
  }

  /*utils.MSG.$emit('axios:begin', item.url);*/
  return fetch({
    ...config,
    ...extraConfig,
  }).then(res => {
    return Promise.resolve(res);
  }).catch(err => {
    return Promise.resolve(err);
  });
});

export default api;
