import fetch from '../fetch';
import { getFollowUpApi, getBasicDataApi, getFollowUpSC } from '@/utils/index'

import utils from './followupUtils';





const headers = {
  sysCode: 45
} /**/
/*工作台*/
export const getTodayAppointsList = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/overView/todayAppoints`),
    method: 'get',
    params: params,
    description: '获取今日预约列表',
  })
};
export const getTodayOverview = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/overView/todayOverview`),
    method: 'get',
    params: params,
    description: '获取今日随访、预约、随访人数',
  })
};
export const getTodayPlans = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/overView/todayPlans`),
    method: 'get',
    params: params,
    description: '查询今日随访计划',
  })
};

/*计划管理*/
export const createFollowPlan = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/plans`),
    method: 'post',
    data: data,
    description: '新增、修改随访计划',
  },)
}
export const getPlanList = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/plans`),
    method: 'get',
    params: params,
    description: '获取计划列表',
  })
};
export const getPlanDetail = (planId) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/plans/${planId}`),
    method: 'get',
    description: '获取计划详情',
  })
};
export const getNodeTimeList = (planId) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/plans/${planId}/time`),
    method: 'get',
    description: '获取随访时间节点列表',
  })
};
export const getNodeTimeContent = (planTimeId) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/plans/time/${planTimeId}`),
    method: 'get',
    description: '获取节点详情',
  })
};
export const getResidentList = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/planPatient/`),
    method: 'get',
    params: params,
    description: '获取居民列表',
  })
};
export const getGroupList = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/planPatient/group`),
    method: 'get',
    params: params,
    description: '获取分组列表',
  })
};
export const getFollowStartTimeList = (planId) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/planPatient/${planId}/times`),
    method: 'get',
    description: '获取随访开始时间列表（居民相关）',
  })
};
export const getResidentDetail = (planId,patientId) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/planPatient/${planId}/detail/${patientId}`),
    method: 'get',
    description: '获取居民详情',
  })
};
export const changePlan = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/planPatient/change`),
    method: 'put',
    data: data,
    description: '变更计划',
  })
};
export const finishPlan = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/planPatient/status`),
    method: 'put',
    data: data,
    description: '变更计划',
  })
};
export const deletePlan = (planId) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/plans/${planId}`),
    method: 'delete',
    description: '删除计划',
  })
};
/*预约管理*/
export const getReservationList = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/appoint/appointed/list`),
    method: 'post',
    data: data,
    description: '获取预约列表',
  })
};
export const getCheckReservation = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/healths/notice/fu/doctor/appoint/pushValid`),
    method: 'post',
    data: data,
    description: '发送预约校验',
  })
};
export const getReservationPatients = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/appoint/appointed/count`),
    method: 'post',
    data: data,
    description: '查看预约人数',
  })
};
export const changeReservationStatus = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/appoint/status/`),
    method: 'post',
    data: data,
    description: '手动变更预约状态',
  })
};
export const sendReservation = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/appoint/`),
    method: 'post',
    data: data,
    description: '发送预约',
  })
};
/*录入管理*/
export const getEnteringList = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/entering/list`),
    method: 'post',
    data: data,
    description: '录入列表查看',
  })
}
export const changeEnteringStatus = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/entering/status/change`),
    method: 'post',
    data: data,
    description: '变更随访状态',
  },)
}
export const getEnteringInfo = (patientId, fuPlanPatientTimesId) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/entering/${patientId}/fuInfo/${fuPlanPatientTimesId}`),
    method: 'get',
    // params: params,
    description: '随访单条信息查看',
  },)
}
export const getFormList = (planTimesId) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/entering/scale/${planTimesId}/list`),
    method: 'get',
    // params: params,
    description: '获取量表列表',
  },)
}

//获取新建计划居民列表
export const getPlanPatientsList = (data) =>{
  return fetch({
    headers:{
      sysCode: 9
    },
    url: getFollowUpSC(`/healths/patients/infolist`),
    method: 'post',
    data: data,
    description: '获取新建计划居民列表',
  },)
}

// 获取随访计划模板列表
export const getFollowupTemplate = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/plans/templets`),
    method: 'get',
    data: data,
    description: '获取随访计划模板列表',
  })
}

// 获取随访量表固定模板
export const getFollowupTableTemplate = (id) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/plans/templets/${id}`),
    method: 'get',
    data: {},
    description: '获取随访量表固定模板',
  })
}

// 获取量表列表
export const getFormOptions = (data)=>{
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/entering/scale/list`),
    method: 'get',
    data: data,
    description: '获取量表列表',
  })
}

/*常量*/
export const getBasicData = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/basic-data/constants/`),
    method: 'get',
    params: params,
    description: '获取常量',
  })
};

// 获取所有漫画列表
export const getAllEducationComtent = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/healths/comtent/workstation/list`),
    method: 'post',
    data: data,
    description: '获取所有漫画列表'
  })
}

// 获取所有疾病
export const getAllDiseases = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/healths/patients/diseases/-1`),
    method: 'get',
    params: params,
    description: '获取所有疾病',
  })
}

// 获取所有分组
export const getAllLabels = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/healths/labels/`),
    method: 'get',
    params: params,
    description: '获取所有分组',
  })
}

// 获取微信和短信病人数接口
export const getPatientNumber = (data) => {
  return fetch({
    headers: {
      sysCode: 9
    },
    url: getFollowUpSC(`/healths/patientEducation/getSendPatientTypeNum`),
    method: 'post',
    data: data,
    description: '获取微信和短信病人数接口',
  })
}
