const customStore = {
  // namespaced: true,
  state: {
    searchParam: {
      orderBy: 2,
      dir: 1,
      grade: 0,
      pageNo: 1,
      pageSize: 10,
      labelIdList: []
    },
    cartList: [],
    courseList: [],
    allLabelList: [],
    subLabelList: [],
    courseLimitCount: -1  // -1: 不限制; 其它值: 限制的个数
  },
  mutations: {
    SET_SEARCH_PARAM: (state, searchParam) => {
      state.searchParam = searchParam;
    },    
    SET_CART_LIST: (state, cartList) => {
      state.cartList = cartList;
    },
    SET_COURSE_LIST: (state, courseList) => {
      state.courseList = courseList;
    },    
    SET_ALL_LABEL_LIST: (state, allLabelList) => {
      state.allLabelList = allLabelList;
    },    
    SET_SUB_LABEL_LIST: (state, subLabelList) => {
      state.subLabelList = subLabelList;
    },    
    SET_COURSE_LIMIT_COUNT: (state, courseLimitCount) => {
      state.courseLimitCount = courseLimitCount;
    },
  },
  actions: {
    setSearchParam({ commit }, searchParam) {
      commit('SET_SEARCH_PARAM', searchParam);
    },
    setCartList({ commit }, cartList) {
      commit('SET_CART_LIST', cartList);
    },
    setCourseList({ commit }, courseList) {
      commit('SET_COURSE_LIST', courseList);
    },    
    setAllLabelList({ commit }, allLabelList) {
      commit('SET_ALL_LABEL_LIST', allLabelList);
    },    
    setSubLabelList({ commit }, subLabelList) {
      commit('SET_SUB_LABEL_LIST', subLabelList);
    },    
    setCourseLimitCount({ commit }, courseLimitCount) {
      commit('SET_COURSE_LIMIT_COUNT', courseLimitCount);
    },
  }
}

export default customStore;