const common = {
    state: {
        _token: '',
        idType: '',
        masterAdministratorFlag: false
    },
    mutations: {
        CHANGE_TOKEN: (state, data) => {
            state._token = data
        },
        CHANGE_IDTYPE: (state, data) => {
            state.idType = data
        },
        CHANGE_MASTER: (state, data) => {
            state.masterAdministratorFlag = data
        }
    },
    actions: {
        changeToken({ commit }, tokenData) {
            commit('CHANGE_TOKEN', tokenData)
        },
        changeIdType({ commit }, idTypeData) {
            commit('CHANGE_IDTYPE', idTypeData)
        },
        changeMaster({ commit }, masterData) {
            commit('CHANGE_MASTER', masterData)
        }
    }
}

export default common