export default ($this) => {
  return [
    {
      formType: 'div',
      name: '4.1 颈动脉',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'stenting',
      model: 'stenting',
      label: '支架术（CAS）：',
      disabled: false,
      spanNum: 24,
      options: [
        {label: '否', value: '否', disabled: false},
        {label: '是', value: '是', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否使用支架术', trigger: ['submit','change']}],
      changeFun(e){
        if(e == '是') {
          $this.addComponents.forEach((item,index)=>{
            if(item.formName == 'stroke_011'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                stentingPosition: []
              }
            }
          })
        }
      }
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title2',
      prop: 'stentingPosition',
      model: 'stentingPosition',
      label: '支架术位置：',
      linkageRule: [{name: 'stenting', value: ['是']}],
      disabled: false,
      changeFun: (val) => {
        // console.log(val)
      },
      spanNum: 24,
      options: [
        {label: '左侧', value: '左侧', disabled: false},
        {label: '右侧', value: '右侧', disabled: false},
      ],
      rules: [{required: true, message: '请选择支架术位置', trigger: ['submit']}]
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title3',
      prop: 'leftStentingOperativeTime',
      model: 'leftStentingOperativeTime',
      placeholder: '请选择',
      label: '支架左侧手术时间：',
      linkageRule: [{name: 'stentingPosition', value: ['左侧']}],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      rules: [{required: true, message: '请选择支架左侧手术时间', trigger: ['submit','change']}],
      spanNum: 12,
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title3',
      prop: 'rightStentingOperativeTime',
      model: 'rightStentingOperativeTime',
      placeholder: '请选择',
      label: '支架右侧手术时间：',
      linkageRule: [{name: 'stentingPosition', value: ['右侧']}],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      rules: [{required: true, message: '请选择支架右侧手术时间', trigger: ['submit','change']}],
      spanNum: 12,
    },


    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'endometriodenudation',
      model: 'endometriodenudation',
      label: '内膜剥脱术（CEA）：',
      disabled: false,
      spanNum: 24,
      options: [
        {label: '否', value: '否', disabled: false},
        {label: '是', value: '是', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否使用内膜剥脱术', trigger: ['submit','change']}],
      changeFun(e){
        if(e == '是') {
          $this.addComponents.forEach((item,index)=>{
            if(item.formName == 'stroke_011'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                endarterectomyPosition: []
              }
            }
          })
        }
      }
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title2',
      prop: 'endarterectomyPosition',
      model: 'endarterectomyPosition',
      label: '内膜剥脱术位置：',
      linkageRule: [{name: 'endometriodenudation', value: ['是']}],
      disabled: false,
      changeFun: (val) => {
        // console.log(val)
      },
      spanNum: 24,
      options: [
        {label: '左侧', value: '左侧', disabled: false},
        {label: '右侧', value: '右侧', disabled: false},
      ],
      rules: [{required: true, message: '请选择内膜剥脱术位置', trigger: ['submit']}]
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title3',
      prop: 'leftEndarterectomyOperativeTime',
      model: 'leftEndarterectomyOperativeTime',
      placeholder: '请选择',
      label: '左侧内膜剥脱术手术时间：',
      linkageRule: [{name: 'endarterectomyPosition', value: ['左侧']}],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      rules: [{required: true, message: '请选择左侧内膜剥脱术手术时间', trigger: ['submit','change']}],
      spanNum: 12,
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title3',
      prop: 'rightEndarterectomyOperativeTime',
      model: 'rightEndarterectomyOperativeTime',
      placeholder: '请选择',
      label: '右侧内膜剥脱术手术时间：',
      linkageRule: [{name: 'endarterectomyPosition', value: ['右侧']}],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      rules: [{required: true, message: '请选择右侧内膜剥脱术手术时间', trigger: ['submit','change']}],
      spanNum: 12,
    },

    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'ecIcBypass',
      model: 'ecIcBypass',
      label: '颅内外血管搭桥术：',
      disabled: false,
      spanNum: 24,
      options: [
        {label: '否', value: '否', disabled: false},
        {label: '是', value: '是', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否使用颅内外血管搭桥术', trigger: ['submit','change']}]
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title2',
      prop: 'ecIcBypassTime',
      model: 'ecIcBypassTime',
      placeholder: '请选择',
      label: '颅内外血管搭桥术-手术时间：',
      linkageRule: [{name: 'ecIcBypass', value: ['是']}],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      rules: [{required: true, message: '请选择颅内外血管搭桥术', trigger: ['submit','change']}],
      spanNum: 12,
    },


  ]
}
